/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;

public class SimpleMirrorServer
implements InternalMirrorServer {
    private final String baseUrl;
    private final boolean enabled;
    private final String id;
    private final Date lastSeenDate;
    private final MirrorType mirrorType;
    private final String name;
    private final String productVersion;
    private final String sharedSecret;

    private SimpleMirrorServer(Builder builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "baseUrl");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.lastSeenDate = Objects.requireNonNull(builder.lastSeenDate, "lastSeenDate");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.productVersion = Objects.requireNonNull(builder.productVersion, "productVersion");
        this.enabled = builder.enabled;
        this.mirrorType = Objects.requireNonNull(builder.mirrorType, "mirrorType");
        this.sharedSecret = Objects.requireNonNull(builder.sharedSecret, "sharedSecret");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMirrorServer that = (SimpleMirrorServer)o;
        return this.enabled == that.enabled && Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.id, that.id) && Objects.equals(this.lastSeenDate, that.lastSeenDate) && this.mirrorType == that.mirrorType && Objects.equals(this.name, that.name) && Objects.equals(this.productVersion, that.productVersion) && Objects.equals(this.sharedSecret, that.sharedSecret);
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Date getLastSeenDate() {
        return this.lastSeenDate;
    }

    @Override
    @Nonnull
    public MirrorType getMirrorType() {
        return this.mirrorType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    @Nonnull
    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseUrl, this.enabled, this.id, this.lastSeenDate, this.mirrorType, this.name, this.productVersion, this.sharedSecret});
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private String baseUrl;
        private boolean enabled;
        private String id;
        private Date lastSeenDate;
        private MirrorType mirrorType;
        private String name;
        private String productVersion;
        private String sharedSecret;

        public Builder() {
        }

        public Builder(InternalMirrorServer other) {
            this.baseUrl = other.getBaseUrl();
            this.enabled = other.isEnabled();
            this.id = other.getId();
            this.lastSeenDate = other.getLastSeenDate();
            this.name = other.getName();
            this.mirrorType = other.getMirrorType();
            this.productVersion = other.getProductVersion();
            this.sharedSecret = other.getSharedSecret();
        }

        public Builder baseUrl(String value) {
            this.baseUrl = Objects.requireNonNull(value, "baseUrl");
            return this;
        }

        public SimpleMirrorServer build() {
            return new SimpleMirrorServer(this);
        }

        public Builder mirror(String id, String name, MirrorType mirrorType) {
            this.id = Objects.requireNonNull(id, "id");
            this.name = Objects.requireNonNull(name, "name");
            this.mirrorType = Objects.requireNonNull(mirrorType, "mirrorType");
            return this;
        }

        public Builder lastSeenDate(Date value) {
            this.lastSeenDate = Objects.requireNonNull(value, "lastSeenDate");
            return this;
        }

        public Builder productVersion(String version) {
            this.productVersion = Objects.requireNonNull(version, "version");
            return this;
        }

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder sharedSecret(String value) {
            this.sharedSecret = Objects.requireNonNull(value, "sharedSecret");
            return this;
        }
    }
}

