/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.atst;

import com.atlassian.bitbucket.internal.mirroring.upstream.DefaultSmartMirroringFeature;
import com.atlassian.bitbucket.mirroring.upstream.MirrorService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;

public class MirrorsSupportData
extends RootLevelSupportDataAppender {
    private static final String MIRORRING_UPSTREAM = "bitbucket.atst.mirroring.upstream";
    private static final String ENABLED = "bitbucket.atst.mirroring.upstream.enabled";
    private static final String MIRROR = "bitbucket.atst.mirroring.upstream.mirror";
    private static final String MIRROR_BASE_URL = "bitbucket.atst.mirroring.upstream.mirror.baseurl";
    private static final String MIRROR_ENABLED = "bitbucket.atst.mirroring.upstream.mirror.enabled";
    private static final String MIRROR_ID = "bitbucket.atst.mirroring.upstream.mirror.id";
    private static final String MIRROR_LAST_SEEN = "bitbucket.atst.mirroring.upstream.mirror.last.seen";
    private static final String MIRROR_NAME = "bitbucket.atst.mirroring.upstream.mirror.name";
    private static final String MIRROR_VERSION = "bitbucket.atst.mirroring.upstream.mirror.version";
    private final MirrorService mirrorService;
    private final DefaultSmartMirroringFeature mirroringFeature;

    public MirrorsSupportData(DefaultSmartMirroringFeature mirroringFeature, MirrorService mirrorService) {
        this.mirroringFeature = mirroringFeature;
        this.mirrorService = mirrorService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        boolean enabled = this.mirroringFeature.isEnabled();
        SupportDataBuilder categoryBuilder = supportDataBuilder.addCategory(MIRORRING_UPSTREAM);
        categoryBuilder.addValue(ENABLED, Boolean.toString(enabled));
        if (enabled) {
            PageUtils.toStream(this.mirrorService::findAll, (int)1000).forEach(server -> categoryBuilder.addCategory(MIRROR).addValue(MIRROR_BASE_URL, server.getBaseUrl()).addValue(MIRROR_ENABLED, String.valueOf(server.isEnabled())).addValue(MIRROR_ID, server.getId()).addValue(MIRROR_LAST_SEEN, server.getLastSeenDate().toString()).addValue(MIRROR_NAME, server.getName()).addValue(MIRROR_VERSION, server.getProductVersion()).addContext(server));
        }
    }
}

