/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.auth;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.AuthenticationSystemException;
import com.atlassian.bitbucket.auth.CaptchaRequiredAuthenticationException;
import com.atlassian.bitbucket.auth.SshAuthenticationExpiredKeyException;
import com.atlassian.bitbucket.auth.SshAuthenticationInsecureKeyException;
import com.atlassian.bitbucket.dmz.permission.DmzPermissionService;
import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveGlobalPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveRepositoryPermission;
import com.atlassian.bitbucket.dmz.ssh.DmzPublicKeyCodec;
import com.atlassian.bitbucket.dmz.ssh.SshAuthenticationSuccessEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.auth.BearerTokenCredentials;
import com.atlassian.bitbucket.internal.mirroring.auth.Credentials;
import com.atlassian.bitbucket.internal.mirroring.auth.CredentialsVisitor;
import com.atlassian.bitbucket.internal.mirroring.auth.SshCredentials;
import com.atlassian.bitbucket.internal.mirroring.auth.UsernamePasswordCredentials;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.internal.mirroring.upstream.SmartMirroringFeature;
import com.atlassian.bitbucket.internal.mirroring.upstream.auth.MirrorAuthenticationService;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.internal.mirroring.user.SimpleApplicationUserWithPermissions;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.ssh.SshKeySettingsService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.security.PublicKey;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMirrorAuthenticationService
implements MirrorAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirrorAuthenticationService.class);
    private final AuthenticationContext authenticationContext;
    private final AuthenticationService authenticationService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final SmartMirroringFeature mirroringFeature;
    private final InternalMirrorService mirrorServerService;
    private final DmzPermissionService permissionService;
    private final DmzPublicKeyCodec publicKeyCodec;
    private final RepositorySupplier repositorySupplier;
    private final SshKeyService sshKeyService;
    private final SshKeySettingsService sshKeySettingsService;
    private final Validator validator;

    @Autowired
    public DefaultMirrorAuthenticationService(AuthenticationContext authenticationContext, AuthenticationService authenticationService, EventPublisher eventPublisher, I18nService i18nService, InternalMirrorService mirrorServerService, SmartMirroringFeature mirroringFeature, DmzPermissionService permissionService, DmzPublicKeyCodec publicKeyCodec, RepositorySupplier repositorySupplier, SshKeyService sshKeyService, SshKeySettingsService sshKeySettingsService, Validator validator) {
        this.authenticationContext = authenticationContext;
        this.authenticationService = authenticationService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mirrorServerService = mirrorServerService;
        this.mirroringFeature = mirroringFeature;
        this.permissionService = permissionService;
        this.publicKeyCodec = publicKeyCodec;
        this.repositorySupplier = repositorySupplier;
        this.sshKeyService = sshKeyService;
        this.sshKeySettingsService = sshKeySettingsService;
        this.validator = validator;
    }

    @Override
    public ApplicationUserWithPermissions authenticateForUser(@Nonnull Credentials credentials, final @Nullable Integer repositoryId) {
        this.mirroringFeature.checkEnabled();
        MirrorServer mirror = this.mirrorServerService.getForUser(this.authenticationContext.getCurrentUser());
        if (mirror == null || !mirror.isEnabled()) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.permission.denied", new Object[0]));
        }
        ValidationUtils.validate((Validator)this.validator, (Object)credentials, (Class[])new Class[0]);
        return credentials.accept(new CredentialsVisitor<ApplicationUserWithPermissions>(){

            @Override
            public ApplicationUserWithPermissions visit(@Nonnull SshCredentials credentials) {
                return DefaultMirrorAuthenticationService.this.performPublicKeyAuthentication(credentials);
            }

            @Override
            public ApplicationUserWithPermissions visit(@Nonnull UsernamePasswordCredentials credentials) {
                return DefaultMirrorAuthenticationService.this.performUsernamePasswordAuthentication(credentials, repositoryId);
            }

            @Override
            public ApplicationUserWithPermissions visit(@Nonnull BearerTokenCredentials credentials) {
                return DefaultMirrorAuthenticationService.this.performTokenAuthentication(credentials, repositoryId);
            }
        });
    }

    private Optional<EffectivePermission> getHighestGlobalPermission() {
        Permission permission = null;
        if (this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            permission = this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) ? Permission.SYS_ADMIN : Permission.ADMIN;
        } else if (this.permissionService.hasGlobalPermission(Permission.LICENSED_USER)) {
            permission = Permission.LICENSED_USER;
        }
        return Optional.ofNullable(permission).map(SimpleEffectiveGlobalPermission::new);
    }

    private Optional<EffectivePermission> getHighestRepositoryPermission(int repositoryId) {
        try {
            Repository repository = this.repositorySupplier.getById(repositoryId);
            if (repository == null) {
                return Optional.empty();
            }
            Permission permission = Permission.REPO_READ;
            if (this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE)) {
                permission = this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN) ? Permission.REPO_ADMIN : Permission.REPO_WRITE;
            }
            return Optional.of(new SimpleEffectiveRepositoryPermission(repositoryId, permission));
        }
        catch (AuthorisationException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<EffectivePermission> getPermissions(Authentication authentication, Integer repositoryId) {
        Authentication previous = this.authenticationService.set(authentication);
        try {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            this.getHighestGlobalPermission().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            if (repositoryId != null) {
                this.getHighestRepositoryPermission(repositoryId).ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            }
            ImmutableSet immutableSet = builder.build();
            return immutableSet;
        }
        finally {
            this.authenticationService.set(previous);
        }
    }

    private ApplicationUserWithPermissions getUserWithPermissions(Integer repoId, Authentication authentication) {
        return authentication.getUser().map(user -> new SimpleApplicationUserWithPermissions((ApplicationUser)user, this.getPermissions(authentication, repoId))).orElse(null);
    }

    private ApplicationUserWithPermissions performPublicKeyAuthentication(SshCredentials sshCredentials) {
        PublicKey publicKey;
        try {
            publicKey = sshCredentials.getAlgorithm() == null ? this.publicKeyCodec.decode(sshCredentials.getPublicKey()) : this.publicKeyCodec.decodeX509Key(sshCredentials.getPublicKey(), sshCredentials.getAlgorithm());
        }
        catch (IllegalArgumentException e) {
            log.info("Mirror SSH authentication failed for {} with {} public key", new Object[]{sshCredentials.getUsername(), sshCredentials.getAlgorithm(), e});
            return null;
        }
        SshKey sshKey = this.sshKeyService.getByPublicKey(publicKey);
        if (sshKey == null || sshKey.getUser() == null) {
            log.debug("Mirror SSH authentication failed for {} with {} public key", (Object)sshCredentials.getUsername(), (Object)sshCredentials.getAlgorithm());
            return null;
        }
        if (sshKey.getType() == KeyType.USER_KEY || sshKey.getType() == KeyType.ACCESS_KEY) {
            if (!this.sshKeySettingsService.meetsMinimumRestrictions(publicKey)) {
                log.debug("Mirror SSH authentication public key {} for {} does not meet requirements", (Object)this.publicKeyCodec.calculateFingerprint(publicKey), (Object)sshKey.getUser().getName());
                throw new SshAuthenticationInsecureKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.sshkey.requirementsNotMet", new Object[]{sshKey.getUser()}));
            }
            if (this.sshKeySettingsService.hasExpired(sshKey)) {
                log.debug("Mirror SSH authentication public key {} is expired for {}", (Object)this.publicKeyCodec.calculateFingerprint(publicKey), (Object)sshKey.getUser().getName());
                throw new SshAuthenticationExpiredKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.sshkey.expired", new Object[0]));
            }
        }
        String tokenDetails = "sshKey {\"id\":\"" + sshKey.getId() + "\", " + (String)(!StringUtils.isEmpty((CharSequence)sshKey.getLabel()) ? "\"label\":\"" + sshKey.getLabel() + "\", " : "") + "\"user.id\":" + sshKey.getUser().getId() + "\", \"name\":\"" + sshKey.getUser().getDisplayName() + "\"}";
        this.eventPublisher.publish((Object)new SshAuthenticationSuccessEvent((Object)this, publicKey, tokenDetails, sshKey.getUser()));
        Iterable effectivePermissions = this.permissionService.getEffectivePermissions(sshKey.getUser());
        List<EffectivePermission> filteredEffectivePermissions = Streams.stream((Iterable)effectivePermissions).map(x -> {
            if (x instanceof EffectiveProjectPermission && x.getPermission() == Permission.REPO_CREATE) {
                return new SimpleEffectiveProjectPermission(((EffectiveProjectPermission)x).getProjectId(), Permission.PROJECT_WRITE);
            }
            return x;
        }).collect(Collectors.toList());
        return new SimpleApplicationUserWithPermissions(sshKey.getUser(), filteredEffectivePermissions);
    }

    private ApplicationUserWithPermissions performTokenAuthentication(BearerTokenCredentials credentials, Integer repoId) {
        Authentication authentication;
        try {
            authentication = this.authenticationService.authenticate(credentials.getToken());
        }
        catch (AuthenticationException e) {
            log.debug("Mirror token authentication failed", (Throwable)e);
            return null;
        }
        return this.getUserWithPermissions(repoId, authentication);
    }

    private ApplicationUserWithPermissions performUsernamePasswordAuthentication(UsernamePasswordCredentials credentials, Integer repoId) {
        Authentication authentication;
        try {
            authentication = this.authenticationService.authenticateWithCaptcha(credentials.getUsername(), credentials.getPassword());
        }
        catch (AuthenticationSystemException | CaptchaRequiredAuthenticationException e) {
            throw e;
        }
        catch (AuthenticationException | NoSuchUserException e) {
            log.debug("Mirror username/password authentication failed for {}", (Object)credentials.getUsername(), (Object)e);
            return null;
        }
        return this.getUserWithPermissions(repoId, authentication);
    }
}

