/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.auth.AbstractMirroringUserAuthenticationHandler;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirrorUserHelper;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class MirrorUserAuthenticationHandler
extends AbstractMirroringUserAuthenticationHandler {
    private final MirrorService mirrorService;
    private final MirrorUserHelper mirrorUserHelper;

    public MirrorUserAuthenticationHandler(AuthenticationContext authenticationContext, I18nService i18nService, MirrorService mirrorService, MirrorUserHelper mirrorUserHelper, TransactionTemplate transactionTemplate) {
        super(authenticationContext, i18nService, transactionTemplate);
        this.mirrorService = mirrorService;
        this.mirrorUserHelper = mirrorUserHelper;
    }

    @Override
    @Nonnull
    protected Optional<ServiceUser> getServiceUser(@Nonnull String jwtIssuerId, @Nonnull HttpAuthenticationContext authenticationContext) {
        Objects.requireNonNull(jwtIssuerId, "jwtIssuerId");
        MirrorServer mirrorServer = this.mirrorService.getById(jwtIssuerId);
        return Optional.ofNullable(mirrorServer).map(ms -> this.mirrorUserHelper.getServiceUser(jwtIssuerId));
    }

    @Override
    protected boolean isMirroringUser(@Nonnull ApplicationUser applicationUser) {
        Objects.requireNonNull(applicationUser, "applicationUser");
        return MirrorUserHelper.isMirrorServiceUser(applicationUser);
    }
}

