/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.jwt.writer.JwtClaimWriter;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserDetailsJwtClaimWriter
implements JwtClaimWriter {
    private final AuthenticationContext authenticationContext;
    private final PermissionService permissionService;

    @Autowired
    public UserDetailsJwtClaimWriter(AuthenticationContext authenticationContext, PermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
    }

    public void write(@Nonnull JwtJsonBuilder builder) {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            ImmutableMap.Builder userBuilder = ImmutableMap.builder().put((Object)"slug", (Object)user.getSlug()).put((Object)"userKey", (Object)String.valueOf(user.getId())).put((Object)"username", (Object)user.getName()).put((Object)"displayName", (Object)user.getDisplayName());
            Permission permission = this.permissionService.getHighestGlobalPermission(user);
            if (permission != null) {
                userBuilder.put((Object)"highestPermission", (Object)permission.name());
            }
            builder.claim("context", (Object)ImmutableMap.of((Object)"user", (Object)userBuilder.build()));
        }
    }
}

