/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.AoMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.MirrorServerDao;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import net.java.ao.EntityStreamCallback;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoMirrorServerDao
extends AbstractAoDao
implements MirrorServerDao {
    @Autowired
    public AoMirrorServerDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public AoMirrorServer create(@Nonnull String id, @Nonnull String baseUrl, @Nonnull String name, @Nonnull MirrorType mirrorType, @Nonnull String productVersion, @Nonnull String sharedSecret, boolean enabled) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)baseUrl), (Object)"baseUrl");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)productVersion), (Object)"productVersion");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sharedSecret), (Object)"sharedSecret");
        return (AoMirrorServer)this.ao.create(AoMirrorServer.class, (Map)ImmutableMap.builder().put((Object)"STATE", (Object)(enabled ? "ENABLED" : "DISABLED")).put((Object)"ID", (Object)id).put((Object)"BASE_URL", (Object)baseUrl).put((Object)"NAME", (Object)name).put((Object)"MIRROR_TYPE", (Object)mirrorType).put((Object)"LAST_SEEN", (Object)new Date()).put((Object)"PRODUCT_VERSION", (Object)productVersion).put((Object)"SHARED_SECRET", (Object)sharedSecret).build());
    }

    @Override
    public void delete(@Nonnull AoMirrorServer mirror) {
        Objects.requireNonNull(mirror, "mirror");
        this.ao.delete(new RawEntity[]{mirror});
    }

    @Override
    @Nonnull
    public Page<AoMirrorServer> findAll(@Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoMirrorServer.class, AoUtils.newQuery((String[])AoMirrorServer.ALL_COLUMNS).order("NAME asc"), Objects.requireNonNull(pageRequest, "pageRequest"));
    }

    @Override
    public AoMirrorServer getById(@Nonnull String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id");
        return (AoMirrorServer)this.ao.get(AoMirrorServer.class, (Object)id);
    }

    @Override
    public boolean hasMirror() {
        return this.ao.count(AoMirrorServer.class) > 0;
    }

    @Override
    public void stream(EntityStreamCallback<AoMirrorServer, String> callback) {
        this.ao.stream(AoMirrorServer.class, AoUtils.newQuery((String[])AoMirrorServer.ALL_COLUMNS).order("NAME asc"), callback);
    }

    private AoMirrorServer getByIdOrFail(String id) {
        Objects.requireNonNull(id, "id");
        AoMirrorServer mirror = this.getById(id);
        Preconditions.checkArgument((mirror != null ? 1 : 0) != 0, (String)"No mirror exists for id %s", (Object)id);
        return mirror;
    }
}

