/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequestState;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirroringRequestSearchRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.AoMirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.MirroringRequestDao;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AoMirroringRequestDao
extends AbstractAoDao
implements MirroringRequestDao {
    @Autowired
    public AoMirroringRequestDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public int countInState(@Nonnull MirroringRequestState state) {
        return this.ao.count(AoMirroringRequest.class, AoUtils.newQuery((String[])new String[0]).where("STATE = ?", new Object[]{state}));
    }

    @Override
    @Nonnull
    public AoMirroringRequest create(@Nonnull MirroringRequest request) {
        ImmutableMap params = ImmutableMap.builder().put((Object)"MIRROR_ID", (Object)request.getMirrorId()).put((Object)"BASE_URL", (Object)request.getBaseUrl()).put((Object)"MIRROR_NAME", (Object)request.getMirrorName()).put((Object)"MIRROR_TYPE", (Object)request.getMirrorType()).put((Object)"PRODUCT_VERSION", (Object)request.getProductVersion()).put((Object)"STATE", (Object)MirroringRequestState.PENDING).put((Object)"CREATED_DATE", (Object)new Date()).build();
        return (AoMirroringRequest)this.ao.create(AoMirroringRequest.class, (Map)params);
    }

    @Override
    public boolean delete(int id) {
        AoMirroringRequest request = (AoMirroringRequest)this.ao.get(AoMirroringRequest.class, (Object)id);
        if (request != null) {
            this.ao.delete(new RawEntity[]{request});
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Page<AoMirroringRequest> findAll(@Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoMirroringRequest.class, AoUtils.newQuery((String[])AoMirroringRequest.ALL_COLUMNS).order("MIRROR_NAME asc"), pageRequest);
    }

    @Override
    @Nonnull
    public Page<AoMirroringRequest> findAll(MirroringRequestSearchRequest searchRequest, PageRequest pageRequest) {
        String mirrorId;
        Query query = AoUtils.newQuery((String[])AoMirroringRequest.ALL_COLUMNS).order("MIRROR_NAME asc");
        HashMap<String, Object> whereClause = new HashMap<String, Object>(2);
        MirroringRequestState state = searchRequest.getState();
        if (state != null) {
            whereClause.put("STATE = ?", (Object)state);
        }
        if ((mirrorId = searchRequest.getMirrorId()) != null) {
            whereClause.put("MIRROR_ID = ?", mirrorId);
        }
        if (!whereClause.isEmpty()) {
            query.where(String.join((CharSequence)" AND ", whereClause.keySet()), whereClause.values().toArray());
        }
        return this.pageQuery(AoMirroringRequest.class, query, pageRequest);
    }

    @Override
    @Nonnull
    public Page<AoMirroringRequest> findByMirrorId(@Nonnull String mirrorId, @Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoMirroringRequest.class, AoUtils.newQuery((String[])AoMirroringRequest.ALL_COLUMNS).where("MIRROR_ID = ?", new Object[]{mirrorId}).order("MIRROR_NAME asc"), pageRequest);
    }

    @Override
    public AoMirroringRequest getById(int id) {
        return (AoMirroringRequest)this.ao.get(AoMirroringRequest.class, (Object)id);
    }

    @Override
    @Nonnull
    public AoMirroringRequest resolve(int id, @Nonnull MirroringRequestState resolution, int resolverUserId) {
        Objects.requireNonNull(resolution, "resolution");
        Preconditions.checkArgument((resolution != MirroringRequestState.PENDING ? 1 : 0) != 0, (Object)"You cannot resolve a request with the 'PENDING' resolution");
        AoMirroringRequest request = this.getByIdOrFail(id);
        request.setState(resolution);
        request.setResolverId(resolverUserId);
        request.setResolvedDate(new Date());
        request.save();
        return request;
    }

    private AoMirroringRequest getByIdOrFail(int id) {
        AoMirroringRequest request = this.getById(id);
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"No mirroring request exists for id %s", (int)id);
        return request;
    }
}

