/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.v0.AoMirroringRequestV0;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.v1.AoMirrorServerV1;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.function.BiConsumer;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.Table;

public class AddMirrorTypeUpgradeTaskV0toV1
implements ActiveObjectsUpgradeTask {
    private static final int PAGE_SIZE = 500;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This task can only upgrade from version 0 to 1");
        ao.migrate(new Class[]{AoMirroringRequestV0toV1.class, AoMirrorServerV1.class});
        this.updateMirrorTypeColumn(ao, AoMirroringRequestV0toV1.class, AoMirroringRequestV0toV1::setMirrorType);
        this.updateMirrorTypeColumn(ao, AoMirrorServerV1.class, AoMirrorServerV1::setMirrorType);
    }

    private <T extends RawEntity<K>, K> void updateMirrorTypeColumn(ActiveObjects ao, Class<T> table, BiConsumer<T, MirrorType> updater) {
        boolean fullPageRetrieved;
        while (fullPageRetrieved = ((Boolean)ao.executeInTransaction(() -> {
            RawEntity[] requests;
            for (RawEntity request : requests = ao.find(table, Query.select().where("MIRROR_TYPE IS null", new Object[0]).limit(500))) {
                updater.accept(request, MirrorType.SINGLE);
                request.save();
            }
            return requests.length == 500;
        })).booleanValue()) {
        }
    }

    @Table(value="MIRRORING_REQUEST")
    @Preload
    public static interface AoMirroringRequestV0toV1
    extends AoMirroringRequestV0 {
        public static final String MIRROR_TYPE_COLUMN = "MIRROR_TYPE";

        @Accessor(value="MIRROR_TYPE")
        public MirrorType getMirrorType();

        @Mutator(value="MIRROR_TYPE")
        public void setMirrorType(@Nonnull MirrorType var1);
    }
}

