/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.dao.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.v2.AoMirrorServerV2;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import net.java.ao.Query;

public class AddSharedSecretInMirrorServerUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final int PAGE_SIZE = 500;
    private final SecureTokenGenerator secureTokenGenerator;

    public AddSharedSecretInMirrorServerUpgradeTask(SecureTokenGenerator secureTokenGenerator) {
        this.secureTokenGenerator = secureTokenGenerator;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Page<AoMirrorServerV2> page;
        Preconditions.checkArgument((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"1")), (Object)"This task can only upgrade from version 1 to 2");
        ao.migrate(new Class[]{AoMirrorServerV2.class});
        while (!(page = this.setSharedSecretForBatch(ao)).getIsLastPage()) {
        }
    }

    private Page<AoMirrorServerV2> setSharedSecretForBatch(ActiveObjects ao) {
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)500);
        return (Page)ao.executeInTransaction(() -> {
            Query query = AoUtils.restrict((Query)Query.select().where("SHARED_SECRET IS null", new Object[0]), (PageRequest)pageRequest);
            ImmutableList aoMirrorServers = ImmutableList.copyOf((Object[])((AoMirrorServerV2[])ao.find(AoMirrorServerV2.class, query)));
            aoMirrorServers.forEach(mirror -> {
                mirror.setSharedSecret(this.secureTokenGenerator.generateToken());
                mirror.save();
            });
            return PageUtils.createPage((Iterable)aoMirrorServers, (PageRequest)pageRequest);
        });
    }
}

