/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.handshake;

import com.atlassian.bitbucket.dmz.cluster.DmzClusterService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.jwt.writer.JwtClaimWriter;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="handshakeIdJwtClaimWriter")
public class HandshakeIdJwtClaimWriter
implements JwtClaimWriter {
    private final DmzClusterService clusterService;
    private final boolean handshakeEnabled;

    @Autowired
    public HandshakeIdJwtClaimWriter(DmzClusterService clusterService, ApplicationPropertiesService propertiesService) {
        this.clusterService = clusterService;
        this.handshakeEnabled = propertiesService.getPluginProperty("plugin.mirroring.handshake.enabled", true);
    }

    public void write(@Nonnull JwtJsonBuilder builder) {
        if (this.handshakeEnabled) {
            builder.claim("context", Map.of("handshakeId", this.clusterService.getClusterId()));
        }
    }
}

