/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.mirror;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.JwtGenerator;
import com.atlassian.bitbucket.mirroring.upstream.MirrorConnectionException;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorClient {
    private static final Logger log = LoggerFactory.getLogger(MirrorClient.class);
    private final HttpClient httpClient;
    private final I18nService i18nService;
    private final JwtGenerator jwtGenerator;

    @Autowired
    public MirrorClient(HttpClient httpClient, JwtGenerator jwtGenerator, I18nService i18nService) {
        this.httpClient = httpClient;
        this.i18nService = i18nService;
        this.jwtGenerator = jwtGenerator;
    }

    @Nonnull
    public Response delete(@Nonnull InternalMirrorServer mirror, @Nonnull String relativeUrl, boolean authorize) {
        Objects.requireNonNull(mirror, "mirror");
        Objects.requireNonNull(relativeUrl, "relativeUrl");
        Request.Builder builder = this.httpClient.newRequest(MirrorClient.concatUrl(mirror.getBaseUrl(), relativeUrl));
        return this.execute(mirror, relativeUrl, authorize, builder, Request.Method.DELETE);
    }

    @Nonnull
    public Response get(@Nonnull InternalMirrorServer mirror, @Nonnull String relativeUrl, boolean authorize) {
        Objects.requireNonNull(mirror, "mirror");
        Objects.requireNonNull(relativeUrl, "relativeUrl");
        Request.Builder builder = this.httpClient.newRequest(MirrorClient.concatUrl(mirror.getBaseUrl(), relativeUrl));
        return this.execute(mirror, relativeUrl, authorize, builder, Request.Method.GET);
    }

    @Nonnull
    public Response post(@Nonnull InternalMirrorServer mirror, @Nonnull String relativeUrl, boolean authorize, @Nullable String requestBody) {
        Objects.requireNonNull(mirror, "mirror");
        Objects.requireNonNull(relativeUrl, "relativeUrl");
        Request.Builder builder = this.httpClient.newRequest(MirrorClient.concatUrl(mirror.getBaseUrl(), relativeUrl)).setHeader("Content-Type", "application/json");
        if (requestBody != null) {
            builder.setEntity(requestBody);
        }
        return this.execute(mirror, relativeUrl, authorize, builder, Request.Method.POST);
    }

    @Nonnull
    public Response put(@Nonnull InternalMirrorServer mirror, @Nonnull String relativeUrl, boolean authorize, @Nullable String requestBody) {
        Objects.requireNonNull(mirror, "mirror");
        Objects.requireNonNull(relativeUrl, "relativeUrl");
        Request.Builder builder = this.httpClient.newRequest(MirrorClient.concatUrl(mirror.getBaseUrl(), relativeUrl)).setHeader("Content-Type", "application/json");
        if (requestBody != null) {
            builder.setEntity(requestBody);
        }
        return this.execute(mirror, relativeUrl, authorize, builder, Request.Method.PUT);
    }

    private static URI concatUrl(String baseUrl, String relativeUrl) {
        return URI.create(StringUtils.stripEnd((String)baseUrl, (String)"/") + StringUtils.prependIfMissing((String)relativeUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    private Response execute(InternalMirrorServer mirror, String relativeUrl, boolean authorize, Request.Builder builder, Request.Method requestMethod) {
        if (authorize) {
            String jwt = this.jwtGenerator.generate(mirror, relativeUrl, requestMethod.name());
            builder.setHeader("Authorization", "JWT " + jwt);
        }
        try {
            return (Response)builder.execute(requestMethod).claim();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                log.debug("Error while connecting to mirror with base URL '{}'", (Object)mirror.getBaseUrl(), (Object)e);
                throw new MirrorConnectionException(this.i18nService.createKeyedMessage("bitbucket.mirroring.mirror.connection.error", new Object[]{mirror.getName()}), e.getCause());
            }
            log.warn("Unknown error while making a request to the mirror with base URL '{}'", (Object)mirror.getBaseUrl(), (Object)e);
            throw e;
        }
    }
}

