/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.mirror;

import com.atlassian.bitbucket.dmz.cluster.DmzClusterService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.UpstreamConstants;
import com.atlassian.bitbucket.internal.mirroring.upstream.mirror.MirrorClient;
import com.atlassian.bitbucket.mirroring.upstream.MirrorIntegrationFailedException;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.httpclient.api.Response;
import com.atlassian.oauth.consumer.ConsumerService;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorLifecycleManager {
    private static final String MIRROR_REST_URL_PATH = "/rest/mirroring/latest";
    private static final Logger log = LoggerFactory.getLogger(MirrorLifecycleManager.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final DmzClusterService clusterService;
    private final ConsumerService consumerService;
    private final I18nService i18nService;
    private final MirrorClient mirrorClient;

    @Autowired
    public MirrorLifecycleManager(DmzClusterService clusterService, ConsumerService consumerService, I18nService i18nService, MirrorClient mirrorClient) {
        this.clusterService = clusterService;
        this.consumerService = consumerService;
        this.i18nService = i18nService;
        this.mirrorClient = mirrorClient;
    }

    public void onInstalled(@Nonnull InternalMirrorServer mirrorServer) {
        Objects.requireNonNull(mirrorServer, "mirrorServer");
        this.invokeInstalledCallback(mirrorServer, false, "bitbucket.mirroring.install.failed.notify.error");
    }

    public void onUninstalled(@Nonnull InternalMirrorServer mirrorServer) {
        Objects.requireNonNull(mirrorServer, "mirrorServer");
        try {
            Response response = this.mirrorClient.post(mirrorServer, "/rest/mirroring/latest/lifecycle/uninstalled", MirrorLifecycleManager.isCompatibleVersion(mirrorServer), null);
            if (!response.isSuccessful()) {
                String responseBody = response.getEntity();
                log.warn("Failed to invoke the uninstalled hook on the mirror with ID {}, received status code {}{}", new Object[]{mirrorServer.getId(), response.getStatusCode(), log.isTraceEnabled() && StringUtils.isNotEmpty((CharSequence)responseBody) ? "\n" + responseBody : ""});
                return;
            }
            log.debug("Invoked un-installed callback on the mirror with ID {}", (Object)mirrorServer.getId());
        }
        catch (RuntimeException e) {
            log.warn("Failed to invoke the uninstalled hook on the mirror with ID {}", (Object)mirrorServer.getId(), (Object)(log.isDebugEnabled() ? e : null));
        }
    }

    public void onUpgraded(@Nonnull InternalMirrorServer mirrorServer) {
        Objects.requireNonNull(mirrorServer, "mirrorServer");
        this.invokeInstalledCallback(mirrorServer, true, "bitbucket.mirroring.upgrade.failed.notify.error");
    }

    private static boolean isCompatibleVersion(InternalMirrorServer mirrorServer) {
        return new Version(mirrorServer.getProductVersion()).compareTo(UpstreamConstants.MINIMUM_COMPATIBLE_MIRROR_VERSION) >= 0;
    }

    private void invokeInstalledCallback(InternalMirrorServer mirrorServer, boolean authorize, String messageKey) {
        String requestBody;
        String issuerId = this.consumerService.getConsumer().getKey();
        try {
            requestBody = objectMapper.writeValueAsString((Object)new RestMirrorInstalled(issuerId, this.clusterService.getClusterId(), mirrorServer.getSharedSecret()));
        }
        catch (IOException e) {
            log.error("Exception while generating JSON request body for triggering installed callback on mirror {}", (Object)mirrorServer.getId());
            throw new RuntimeException(e);
        }
        Response response = this.mirrorClient.post(mirrorServer, "/rest/mirroring/latest/lifecycle/installed", authorize, requestBody);
        if (!response.isSuccessful()) {
            String responseBody = response.getEntity();
            log.warn("Failed to invoke installed callback on the mirror with ID {}, received status code {}{}", new Object[]{mirrorServer.getId(), response.getStatusCode(), log.isTraceEnabled() && StringUtils.isNotEmpty((CharSequence)responseBody) ? "\n" + responseBody : ""});
            throw new MirrorIntegrationFailedException(this.i18nService.createKeyedMessage(messageKey, new Object[]{mirrorServer.getName()}));
        }
        log.debug("Invoked installed callback on the mirror with ID {}", (Object)mirrorServer.getId());
    }

    private static class RestMirrorInstalled
    extends RestMapEntity {
        private static final String CLIENT_KEY = "clientKey";
        private static final String HANDSHAKE_ID = "handshakeId";
        private static final String SHARED_SECRET = "sharedSecret";

        public RestMirrorInstalled(String clientKey, String handshakeId, String sharedSecret) {
            this.put(CLIENT_KEY, clientKey);
            this.put(HANDSHAKE_ID, handshakeId);
            this.put(SHARED_SECRET, sharedSecret);
        }
    }
}

