/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.mirror;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.internal.mirroring.upstream.mirror.MirrorClient;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.httpclient.api.Response;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorRequestDelegatingService {
    private final I18nService i18nService;
    private final MirrorClient mirrorClient;
    private final InternalMirrorService mirrorService;
    private final PermissionValidationService permissionValidationService;

    @Autowired
    public MirrorRequestDelegatingService(MirrorClient mirrorClient, I18nService i18nService, InternalMirrorService mirrorService, PermissionValidationService permissionValidationService) {
        this.mirrorClient = mirrorClient;
        this.i18nService = i18nService;
        this.mirrorService = mirrorService;
        this.permissionValidationService = permissionValidationService;
    }

    @Nonnull
    public jakarta.ws.rs.core.Response delegateToMirror(@Nonnull String mirrorId, @Nonnull String relativeUrl, @Nonnull RequestType requestType, @Nullable String requestBody) {
        return this.delegateToMirror(mirrorId, relativeUrl, requestType, requestBody, true);
    }

    @Nonnull
    public jakarta.ws.rs.core.Response delegateToMirror(@Nonnull String mirrorId, @Nonnull String relativeUrl, @Nonnull RequestType requestType, @Nullable String requestBody, boolean checkGlobalPermission) {
        Objects.requireNonNull(mirrorId, "mirrorId");
        Objects.requireNonNull(relativeUrl, "relativeUrl");
        Objects.requireNonNull(requestType, "requestType");
        if (checkGlobalPermission) {
            this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        }
        return this.executeRequest(mirrorId, requestType, mirror -> relativeUrl, requestBody);
    }

    private static boolean isBinaryType(String contentType) {
        return contentType != null && MediaType.APPLICATION_OCTET_STREAM_TYPE.isCompatible(MediaType.valueOf((String)contentType));
    }

    private Response doExecute(InternalMirrorServer mirrorServer, String relativeUrl, RequestType requestType, String requestBody) {
        switch (requestType.ordinal()) {
            case 0: {
                return this.mirrorClient.delete(mirrorServer, relativeUrl, true);
            }
            case 3: {
                return this.mirrorClient.put(mirrorServer, relativeUrl, true, requestBody);
            }
            case 2: {
                return this.mirrorClient.post(mirrorServer, relativeUrl, true, requestBody);
            }
        }
        return this.mirrorClient.get(mirrorServer, relativeUrl, true);
    }

    private jakarta.ws.rs.core.Response executeRequest(String mirrorId, RequestType requestType, Function<InternalMirrorServer, String> urlProvider, String requestBody) {
        InternalMirrorServer mirrorServer = this.mirrorService.getById(mirrorId);
        if (mirrorServer == null) {
            return this.notFoundResponse(mirrorId);
        }
        String url = urlProvider.apply(mirrorServer);
        Response mirrorResponse = this.doExecute(mirrorServer, url, requestType, requestBody);
        String contentType = mirrorResponse.getContentType();
        Response.ResponseBuilder responseBuilder = ResponseFactory.status((int)mirrorResponse.getStatusCode()).entity(MirrorRequestDelegatingService.isBinaryType(contentType) ? mirrorResponse.getEntityStream() : mirrorResponse.getEntity()).type(contentType);
        String contentDisposition = mirrorResponse.getHeader("Content-Disposition");
        if (contentDisposition != null) {
            responseBuilder.header("Content-Disposition", (Object)contentDisposition);
        }
        return responseBuilder.build();
    }

    private jakarta.ws.rs.core.Response notFoundResponse(String mirrorId) {
        RestErrors error = new RestErrors.Builder().add(this.i18nService.getMessage("bitbucket.mirroring.no.such.mirror.server", new Object[]{mirrorId})).build();
        return ResponseFactory.notFound().entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static enum RequestType {
        DELETE,
        GET,
        POST,
        PUT;

    }
}

