/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.nav;

import com.atlassian.bitbucket.internal.mirroring.upstream.nav.MirroringMirrorNavBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class DefaultMirroringMirrorNavBuilder
implements MirroringMirrorNavBuilder {
    @Override
    @Nonnull
    public MirroringMirrorNavBuilder.Rest rest() {
        return new RestBuilder();
    }

    private static class RestBuilder
    implements MirroringMirrorNavBuilder.Rest {
        private static final String REST_BASE_API_URL = "/rest/api/latest";
        private static final String REST_BASE_URL = "/rest/mirroring/latest";

        private RestBuilder() {
        }

        @Override
        @Nonnull
        public String farmNodes() {
            return "/rest/mirroring/latest/farmNodes";
        }

        @Override
        @Nonnull
        public String loggingSettings() {
            return "/rest/api/latest/logs/settings";
        }

        @Override
        @Nonnull
        public String repos(int repositoryId) {
            return "/rest/mirroring/latest/mirrorRepos/" + repositoryId;
        }

        @Override
        @Nonnull
        public String syncSettings() {
            return "/rest/mirroring/latest/syncSettings";
        }

        @Override
        @Nonnull
        public MirroringMirrorNavBuilder.RestTroubleshooting troubleshooting() {
            return new RestTroubleshootingBuilder();
        }
    }

    private static class RestTroubleshootingBuilder
    implements MirroringMirrorNavBuilder.RestTroubleshooting {
        private static final String REST_BASE_URL = "/rest/troubleshooting/latest";

        private RestTroubleshootingBuilder() {
        }

        @Override
        @Nonnull
        public String cancelSupportZip(@Nonnull String taskId) {
            Objects.requireNonNull(taskId, "taskId");
            return "/rest/troubleshooting/latest/support-zip/task/" + taskId;
        }

        @Override
        @Nonnull
        public String createSupportZip() {
            return "/rest/troubleshooting/latest/support-zip/cluster";
        }

        @Override
        @Nonnull
        public String supportZipDownload(@Nonnull String fileName) {
            Objects.requireNonNull(fileName, "fileName");
            return "/rest/troubleshooting/latest/support-zip/download/" + fileName;
        }

        @Override
        @Nonnull
        public String supportZipStatus(@Nonnull String clusterTaskId) {
            Objects.requireNonNull(clusterTaskId, "clusterTaskId");
            return "/rest/troubleshooting/latest/support-zip/status/cluster/" + clusterTaskId;
        }
    }
}

