/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.rest.RestAnalyticsSettings;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.plugin.OptionalPluginInformationProvider;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.time.Instant;

@Tag(name="Mirroring (Upstream)")
@UnrestrictedAccess
@Path(value="analyticsSettings")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class AnalyticsRestResource {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final InternalMirrorService mirrorServerService;
    private final OptionalPluginInformationProvider pluginInformationProvider;

    @Inject
    public AnalyticsRestResource(AuthenticationContext authenticationContext, I18nService i18nService, LicenseService licenseService, InternalMirrorService mirrorServerService, OptionalPluginInformationProvider pluginInformationProvider) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.mirrorServerService = mirrorServerService;
        this.pluginInformationProvider = pluginInformationProvider;
    }

    @Operation(description="Gets the analytics settings from the mirroring upstream", summary="Get analytics settings from upstream")
    @ResponseDocs(value={@ResponseDoc(documentation="The analytics settings from upstream", representation=RestAnalyticsSettings.class, responseCode=200)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response analyticsSettings() {
        MirrorServer mirror = this.mirrorServerService.getForUser(this.authenticationContext.getCurrentUser());
        if (mirror == null || !mirror.isEnabled()) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.analytics.permission.denied", new Object[0]));
        }
        this.mirrorServerService.touchLastSeen(mirror.getId());
        boolean canCollectAnalytics = this.pluginInformationProvider.canCollectAnalytics();
        BitbucketServerLicense bitbucketServerLicense = this.licenseService.get();
        String sen = bitbucketServerLicense == null ? "" : (String)MoreObjects.firstNonNull((Object)bitbucketServerLicense.getSupportEntitlementNumber(), (Object)"");
        return ResponseFactory.ok().entity((Object)new RestAnalyticsSettings(canCollectAnalytics, Instant.now().getEpochSecond(), sen)).build();
    }
}

