/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.upstream.mirror.MirrorRequestDelegatingService;
import com.atlassian.bitbucket.internal.mirroring.upstream.nav.MirroringMirrorNavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@UnrestrictedAccess
@Hidden
@Path(value="mirrors/{mirrorId}")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirrorDelegateResource {
    private final I18nService i18nService;
    private final MirroringMirrorNavBuilder navBuilder;
    private final RepositoryService repositoryService;
    private final MirrorRequestDelegatingService service;

    @Inject
    public MirrorDelegateResource(MirrorRequestDelegatingService service, MirroringMirrorNavBuilder navBuilder, RepositoryService repositoryService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.repositoryService = repositoryService;
        this.service = service;
    }

    @GET
    @Path(value="/farmNodes")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getFarmNodes(@PathParam(value="mirrorId") String mirrorId) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().farmNodes(), MirrorRequestDelegatingService.RequestType.GET, null);
    }

    @GET
    @Path(value="/logs/settings")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getLoggingSettings(@PathParam(value="mirrorId") String mirrorId) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().loggingSettings(), MirrorRequestDelegatingService.RequestType.GET, null);
    }

    @GET
    @Path(value="/settings/projects")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirroredProjects(@PathParam(value="mirrorId") String mirrorId) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().syncSettings() + "/projects", MirrorRequestDelegatingService.RequestType.GET, null);
    }

    @GET
    @Path(value="/repos/{repoId}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirroredRepository(@PathParam(value="mirrorId") String mirrorId, @PathParam(value="repoId") int repoId) {
        if (this.repositoryService.getById(repoId) == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.notFound", new Object[]{repoId}), null);
        }
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().repos(repoId), MirrorRequestDelegatingService.RequestType.GET, null, false);
    }

    @GET
    @Path(value="/settings")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirrorSettings(@PathParam(value="mirrorId") String mirrorId) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().syncSettings(), MirrorRequestDelegatingService.RequestType.GET, null);
    }

    @PUT
    @Path(value="/logs/settings")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setLoggingSettings(@PathParam(value="mirrorId") String mirrorId, String requestBody) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().loggingSettings(), MirrorRequestDelegatingService.RequestType.PUT, requestBody);
    }

    @PUT
    @Path(value="/settings/mode")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setMirrorMode(@PathParam(value="mirrorId") String mirrorId, String requestBody) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().syncSettings() + "/mode", MirrorRequestDelegatingService.RequestType.PUT, requestBody);
    }

    @POST
    @Path(value="/settings/projects")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response startMirroringProjects(@PathParam(value="mirrorId") String mirrorId, String requestBody) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().syncSettings() + "/projects", MirrorRequestDelegatingService.RequestType.POST, requestBody);
    }

    @DELETE
    @Path(value="/settings/projects/{projectId}")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response stopMirroringProject(@PathParam(value="mirrorId") String mirrorId, @PathParam(value="projectId") String projectId) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().syncSettings() + "/projects/" + projectId, MirrorRequestDelegatingService.RequestType.DELETE, null);
    }
}

