/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.SimpleMirrorUpgradeRequest;
import com.atlassian.bitbucket.internal.mirroring.rest.RestMirrorUpgradeRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.internal.mirroring.upstream.rest.RestMirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

@Tag(name="Mirroring (Upstream)")
@UnrestrictedAccess
@Path(value="mirrorServers")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirrorServerResource {
    private final I18nService i18nService;
    private final InternalMirrorService mirrorService;
    private final Validator validator;

    @Inject
    public MirrorServerResource(I18nService i18nService, InternalMirrorService mirrorService, Validator validator) {
        this.i18nService = i18nService;
        this.mirrorService = mirrorService;
        this.validator = validator;
    }

    @Operation(description="Returns the mirror specified by a mirror ID", summary="Get mirror by ID")
    @Parameter(description="the mirror ID", in=ParameterIn.PATH, name="mirrorId")
    @ResponseDocs(value={@ResponseDoc(documentation="the mirror", representation=RestMirrorServer.class, responseCode=200), @ResponseDoc(documentation="The mirror could not be found.", restError=true, responseCode=404)})
    @GET
    @Path(value="{mirrorId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirror(@PathParam(value="mirrorId") String mirrorId) {
        InternalMirrorServer mirror = this.mirrorService.getById(mirrorId);
        return mirror == null ? this.notFoundResponse(mirrorId) : ResponseFactory.ok((Object)new RestMirrorServer(mirror)).build();
    }

    @Operation(description="Returns a list of mirrors", summary="Get all mirrors")
    @ResponseDocs(value={@ResponseDoc(documentation="a page of mirrors", paged=true, representation=RestMirrorServer.class, responseCode=200)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response listMirrors(@BeanParam PageRequestResolver pageRequest) {
        return ResponseFactory.ok((Object)new RestPage(this.mirrorService.findAll(pageRequest.getPageRequest()), RestMirrorServer::new)).build();
    }

    @Operation(description="Removes a mirror, disabling all access and notifications for the mirror server in question", summary="Delete mirror by ID")
    @Parameter(description="the ID of the mirror to remove", in=ParameterIn.PATH, name="mirrorId")
    @ResponseDocs(value={@ResponseDoc(documentation="an empty response indicating that the mirror has been removed", responseCode=204)})
    @DELETE
    @Path(value="{mirrorId}")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response remove(@PathParam(value="mirrorId") String mirrorId) {
        this.mirrorService.remove(mirrorId);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Upgrades the mirror server in question with the provided details.This endpoint can only be called by the mirror instance or system administrators<br>Since 5.8", summary="Upgrade mirror server")
    @Parameter(description="the ID of the mirror to upgrade", in=ParameterIn.PATH, name="mirrorId")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestMirrorUpgradeRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="the mirror", representation=RestMirrorServer.class, responseCode=200)})
    @PUT
    @Path(value="{mirrorId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response upgrade(@PathParam(value="mirrorId") String mirrorId, RestMirrorUpgradeRequest upgradeRequest) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)upgradeRequest), (Class[])new Class[0]);
        MirrorServer mirror = this.mirrorService.upgrade(new SimpleMirrorUpgradeRequest.Builder(mirrorId).productVersion(upgradeRequest.getProductVersion()).baseUrl(upgradeRequest.getBaseUrl()).build());
        return mirror == null ? this.notFoundResponse(mirrorId) : ResponseFactory.ok((Object)new RestMirrorServer(mirror)).build();
    }

    private Response notFoundResponse(String mirrorId) {
        RestErrors error = new RestErrors.Builder().add(this.i18nService.getMessage("bitbucket.mirroring.no.such.mirror.server", new Object[]{mirrorId})).build();
        return ResponseFactory.notFound().entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

