/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.upstream.mirror.MirrorRequestDelegatingService;
import com.atlassian.bitbucket.internal.mirroring.upstream.nav.MirroringMirrorNavBuilder;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@UnrestrictedAccess
@Hidden
@Path(value="mirrors/{mirrorId}/troubleshooting")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirrorTroubleshootingDelegateResource {
    private final MirroringMirrorNavBuilder navBuilder;
    private final MirrorRequestDelegatingService service;

    @Inject
    public MirrorTroubleshootingDelegateResource(MirrorRequestDelegatingService service, MirroringMirrorNavBuilder navBuilder) {
        this.navBuilder = navBuilder;
        this.service = service;
    }

    @DELETE
    @Path(value="/support-zip/{taskId}")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cancelSupportZip(@PathParam(value="mirrorId") String mirrorId, @PathParam(value="taskId") String taskId) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().troubleshooting().cancelSupportZip(taskId), MirrorRequestDelegatingService.RequestType.DELETE, null);
    }

    @POST
    @Path(value="/support-zip")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createSupportZip(@PathParam(value="mirrorId") String mirrorId, String requestBody) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().troubleshooting().createSupportZip(), MirrorRequestDelegatingService.RequestType.POST, requestBody);
    }

    @GET
    @Path(value="/support-zip/download/{fileName}")
    @Produces(value={"application/octet-stream"})
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response downloadSupportZip(@PathParam(value="mirrorId") String mirrorId, @PathParam(value="fileName") String fileName) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().troubleshooting().supportZipDownload(fileName), MirrorRequestDelegatingService.RequestType.GET, null);
    }

    @GET
    @Path(value="/support-zip/{clusterTaskId}")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSupportZipProgress(@PathParam(value="mirrorId") String mirrorId, @PathParam(value="clusterTaskId") String clusterTaskId) {
        return this.service.delegateToMirror(mirrorId, this.navBuilder.rest().troubleshooting().supportZipStatus(clusterTaskId), MirrorRequestDelegatingService.RequestType.GET, null);
    }
}

