/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorSynchronizationFailedEvent;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorSynchronizedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.ConstraintViolationUtils;
import com.atlassian.bitbucket.internal.mirroring.repositories.InvalidRepositoryIdFormatException;
import com.atlassian.bitbucket.internal.mirroring.rest.RestRepositoryMirrorEvent;
import com.atlassian.bitbucket.internal.mirroring.rest.RestRepositorySynchronizationFailedEvent;
import com.atlassian.bitbucket.internal.mirroring.rest.RestRepositorySynchronizedEvent;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.bitbucket.util.SimpleNamedLink;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(name="Mirroring (Upstream)")
@UnrestrictedAccess
@Path(value="mirrorServers/{mirrorId}/events")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirroringEventResource {
    private static final Logger log = LoggerFactory.getLogger(MirroringEventResource.class);
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final InternalMirrorService mirrorServerService;
    private final RepositoryService repositoryService;
    private final Validator validator;

    @Inject
    public MirroringEventResource(AuthenticationContext authenticationContext, EventPublisher eventPublisher, I18nService i18nService, InternalMirrorService mirrorServerService, RepositoryService repositoryService, Validator validator) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mirrorServerService = mirrorServerService;
        this.repositoryService = repositoryService;
        this.validator = validator;
    }

    @Operation(description="Publishes a RepositoryMirrorEvent on the event queue.", summary="Publish RepositoryMirrorEvent")
    @Parameter(description="the server id of the mirror that raised this event", in=ParameterIn.PATH, name="mirrorId")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestRepositoryMirrorEvent.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The event was successfully placed on the queue", responseCode=204), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response publishEvent(@PathParam(value="mirrorId") String mirrorId, RestRepositoryMirrorEvent event) {
        MirrorServer mirror = this.mirrorServerService.getForUser(this.authenticationContext.getCurrentUser());
        if (mirror == null || !mirror.isEnabled() || !mirror.getId().equals(mirrorId)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.event.notAccepted", new Object[0]));
        }
        this.validate(event);
        String mirrorName = mirror.getName();
        switch (event.getType()) {
            case SYNCHRONIZATION_FAILED: {
                this.handleSynchronizationFailed(new RestRepositorySynchronizationFailedEvent((Map<String, Object>)((Object)event)), mirrorId, mirrorName);
                break;
            }
            case SYNCHRONIZED: {
                this.handleSynchronized(new RestRepositorySynchronizedEvent((Map<String, Object>)((Object)event)), mirrorId, mirrorName);
                break;
            }
            default: {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.event.type.unknown", new Object[]{event.getType()}));
            }
        }
        return ResponseFactory.noContent().build();
    }

    private void handleSynchronizationFailed(RestRepositorySynchronizationFailedEvent event, String mirrorId, String mirrorName) {
        Repository repository = this.tryGetRepository(event.getUpstreamRepoId());
        log.warn("Failed to synchronize repository[{}/{}] to mirror {}", new Object[]{repository.getId(), event.getMirrorRepoId(), mirrorId});
        RepositoryMirrorSynchronizationFailedEvent upstreamEvent = ((RepositoryMirrorSynchronizationFailedEvent.Builder)((RepositoryMirrorSynchronizationFailedEvent.Builder)((RepositoryMirrorSynchronizationFailedEvent.Builder)((RepositoryMirrorSynchronizationFailedEvent.Builder)new RepositoryMirrorSynchronizationFailedEvent.Builder().source((Object)this)).mirrorServerId(mirrorId)).mirrorServerName(mirrorName)).repository(repository)).build();
        this.eventPublisher.publish((Object)upstreamEvent);
    }

    private void handleSynchronized(RestRepositorySynchronizedEvent event, String mirrorId, String mirrorName) {
        Repository repository = this.tryGetRepository(event.getUpstreamRepoId());
        log.debug("Successful synchronization of repository[{}/{}] updated {} refs, {} refs failed to update on mirror {}", new Object[]{repository.getId(), event.getMirrorRepoId(), event.getRefChanges().size(), event.getFailedRefs().size(), mirrorId});
        RepositoryMirrorSynchronizedEvent upstreamEvent = ((RepositoryMirrorSynchronizedEvent.Builder)((RepositoryMirrorSynchronizedEvent.Builder)((RepositoryMirrorSynchronizedEvent.Builder)((RepositoryMirrorSynchronizedEvent.Builder)new RepositoryMirrorSynchronizedEvent.Builder().source((Object)this)).cloneLinks(this.mapCloneLinks(event)).mirrorServerId(mirrorId)).mirrorServerName(mirrorName)).repository(repository)).failedRefs(this.mapFailedRefs(event)).refChanges(this.mapChangedRefs(event)).refLimitExceeded(event.isRefLimitExceeded()).syncType(event.getSyncType()).build();
        this.eventPublisher.publish((Object)upstreamEvent);
    }

    private List<RefChange> mapChangedRefs(RestRepositorySynchronizedEvent event) {
        return (List)event.getRefChanges().stream().map(refChange -> new SimpleRefChange.Builder(refChange).build()).collect(MoreCollectors.toImmutableList());
    }

    private List<NamedLink> mapCloneLinks(RestRepositorySynchronizedEvent event) {
        return (List)event.getCloneLinks().stream().filter(cloneLink -> StringUtils.isNotBlank((CharSequence)cloneLink.getName())).map(cloneLink -> new SimpleNamedLink(cloneLink.getHref(), cloneLink.getName())).collect(MoreCollectors.toImmutableList());
    }

    private List<MinimalRef> mapFailedRefs(RestRepositorySynchronizedEvent event) {
        return (List)event.getFailedRefs().stream().map(refChange -> new SimpleMinimalRef.Builder(refChange).build()).collect(MoreCollectors.toImmutableList());
    }

    private Repository tryGetRepository(String externalRepositoryId) {
        try {
            int repositoryId = Integer.parseInt(externalRepositoryId);
            Repository repository = this.repositoryService.getById(repositoryId);
            if (repository == null) {
                throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.notFound", new Object[]{externalRepositoryId}), null);
            }
            return repository;
        }
        catch (NumberFormatException e) {
            throw new InvalidRepositoryIdFormatException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.id.invalid", new Object[]{externalRepositoryId, "server"}));
        }
    }

    private void validate(@Nonnull RestRepositoryMirrorEvent event) {
        try {
            ValidationUtils.validate((Validator)this.validator, (Object)((Object)event), (Class[])new Class[0]);
        }
        catch (ConstraintViolationException e) {
            String constraintsMessage = ConstraintViolationUtils.violationToString(e);
            log.info("Mirror event had an unexpected format - ignoring: {}. Error details:", (Object)constraintsMessage, (Object)e);
            throw e;
        }
    }
}

