/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequestState;
import com.atlassian.bitbucket.internal.mirroring.SimpleMirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.rest.RestMirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirroringRequestSearchRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirroringRequestService;
import com.atlassian.bitbucket.internal.mirroring.upstream.rest.RestMirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

@Tag(name="Mirroring (Upstream)")
@UnrestrictedAccess
@Path(value="requests")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirroringRequestResource {
    private final MirroringRequestService mirroringRequestService;
    private final I18nService i18nService;
    private final Validator validator;

    @Inject
    public MirroringRequestResource(MirroringRequestService mirroringRequestService, I18nService i18nService, Validator validator) {
        this.mirroringRequestService = mirroringRequestService;
        this.i18nService = i18nService;
        this.validator = validator;
    }

    @Operation(description="Deletes a mirroring request", summary="Delete a mirroring request")
    @Parameter(name="mirroringRequestId", description="the ID of the mirroring request to delete", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The request was deleted", responseCode=204), @ResponseDoc(documentation="The request could not be found", restError=true, responseCode=409)})
    @DELETE
    @Path(value="{mirroringRequestId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteMirroringRequest(@PathParam(value="mirroringRequestId") int id) {
        this.mirroringRequestService.delete(this.getRequestOrFail(id));
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieves a mirroring request", summary="Get a mirroring request")
    @Parameter(name="mirroringRequestId", description="the ID of the mirroring request to retrieve", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The mirroring request", representation=RestMirroringRequest.class, responseCode=200), @ResponseDoc(documentation="The request could not be found", restError=true, responseCode=409)})
    @GET
    @Path(value="{mirroringRequestId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirroringRequest(@PathParam(value="mirroringRequestId") int id) {
        return ResponseFactory.ok().entity((Object)new RestMirroringRequest(this.getRequestOrFail(id))).build();
    }

    @Operation(description="Retrieves a mirroring request", summary="Get mirroring requests")
    @Parameter(description="(optional) the request state to filter on", in=ParameterIn.QUERY, name="state", schema=@Schema(allowableValues={"PENDING", "ACCEPTED", "REJECTED"}, implementation=String.class))
    @ResponseDocs(value={@ResponseDoc(documentation="A page of mirroring requests", paged=true, representation=RestMirroringRequest.class, responseCode=200)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response listRequests(@BeanParam PageRequestResolver pageRequest, @QueryParam(value="state") String state) {
        MirroringRequestSearchRequest.Builder searchBuilder = new MirroringRequestSearchRequest.Builder();
        if (StringUtils.isNotBlank((CharSequence)state)) {
            searchBuilder.state(MirroringRequestState.fromId(state));
        }
        return ResponseFactory.ok().entity((Object)new RestPage(this.mirroringRequestService.findAll(searchBuilder.build(), pageRequest.getPageRequest()), RestMirroringRequest::new)).build();
    }

    @Operation(description="Creates a new mirroring request", summary="Create a mirroring request")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestMirroringRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The created mirroring request", representation=RestMirroringRequest.class, responseCode=200), @ResponseDoc(documentation="The request was invalid or missing", restError=true, responseCode=409)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response register(RestMirroringRequest request) throws URISyntaxException {
        this.validateSupplied(request != null, "request body");
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        MirroringRequest registered = this.mirroringRequestService.register(new SimpleMirroringRequest.Builder().mirrorServer(request.getMirrorId(), request.getMirrorName(), request.getMirrorType().orElse(MirrorType.SINGLE)).productVersion(request.getProductVersion()).mirrorBaseUrl(request.getMirrorBaseUrl()).build());
        return ResponseFactory.ok((Object)((Object)new RestMirroringRequest(registered))).build();
    }

    @Operation(description="Accepts a mirroring request", summary="Accept a mirroring request")
    @Parameter(description="the ID of the request to accept", name="mirroringRequestId", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The accepted mirror server", representation=RestMirrorServer.class, responseCode=200), @ResponseDoc(documentation="The request could not be found", restError=true, responseCode=409)})
    @POST
    @Path(value="{mirroringRequestId}/accept")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response accept(@PathParam(value="mirroringRequestId") int id) {
        MirrorServer mirror = this.mirroringRequestService.accept(this.getRequestOrFail(id));
        return ResponseFactory.ok().entity((Object)new RestMirrorServer(mirror)).build();
    }

    @Operation(description="Rejects a mirroring request", summary="Reject a mirroring request")
    @Parameter(description="the ID of the request to reject", name="mirroringRequestId", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The rejected mirror server", representation=RestMirrorServer.class, responseCode=200), @ResponseDoc(documentation="The request could not be found", restError=true, responseCode=409)})
    @POST
    @Path(value="{mirroringRequestId}/reject")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response reject(@PathParam(value="mirroringRequestId") int id) {
        MirroringRequest request = this.getRequestOrFail(id);
        return ResponseFactory.ok().entity((Object)new RestMirroringRequest(this.mirroringRequestService.reject(request))).build();
    }

    private MirroringRequest getRequestOrFail(int id) {
        MirroringRequest request = this.mirroringRequestService.getById(id);
        if (request == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.mirroring.requests.notFound", new Object[]{id}));
        }
        return request;
    }

    private void validateSupplied(boolean expression, String field) {
        if (!expression) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.argument.notSpecified", new Object[]{field}));
        }
    }
}

