/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.upstream.rest.RestMirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorService;
import com.atlassian.bitbucket.mirroring.upstream.MirroringUserSettingsService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

@Tag(name="Mirroring (Upstream)")
@UnrestrictedAccess
@Path(value="account/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirroringUserSettingsResource {
    private final MirrorService mirrorService;
    private final MirroringUserSettingsService mirroringUserSettingsService;

    @Inject
    MirroringUserSettingsResource(MirrorService mirrorService, MirroringUserSettingsService mirroringUserSettingsService) {
        this.mirrorService = mirrorService;
        this.mirroringUserSettingsService = mirroringUserSettingsService;
    }

    @Operation(description="Sets the mirror specified by a mirror ID as the current user's preferred mirror", summary="Set preferred mirror")
    @RequestBody(description="the mirror ID", content={@Content(schema=@Schema(implementation=String.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="an empty response indicating that the user setting has been updated", responseCode=204), @ResponseDoc(documentation="The mirror could not be found.", restError=true, responseCode=404)})
    @POST
    @Path(value="preferred-mirror")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPreferredMirrorId(String mirrorId) {
        MirrorServer mirrorServer = this.mirrorService.getById(mirrorId);
        if (mirrorServer != null) {
            this.mirroringUserSettingsService.setPreferredMirror(mirrorServer);
            return ResponseFactory.noContent().build();
        }
        return ResponseFactory.notFound().build();
    }

    @Operation(description="Retrieves the current user's preferred mirror server", summary="Get preferred mirror")
    @ResponseDocs(value={@ResponseDoc(documentation="the preferred mirror server", representation=RestMirrorServer.class, responseCode=200), @ResponseDoc(documentation="The user's preferred mirror server could not be found.", restError=true, responseCode=404)})
    @GET
    @Path(value="preferred-mirror")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPreferredMirrorId() {
        Optional<MirrorServer> mirrorServer = this.mirroringUserSettingsService.getPreferredMirror();
        if (mirrorServer.isPresent()) {
            return ResponseFactory.ok().entity((Object)new RestMirrorServer(mirrorServer.get())).build();
        }
        return ResponseFactory.notFound().build();
    }

    @Operation(description="Removes the current user's preferred mirror", summary="Remove preferred mirror")
    @ResponseDocs(value={@ResponseDoc(documentation="an empty response indicating that the user setting has been updated", responseCode=204)})
    @DELETE
    @Path(value="preferred-mirror")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deletePreferredMirrorId() {
        this.mirroringUserSettingsService.removePreferredMirror();
        return ResponseFactory.noContent().build();
    }
}

