/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.upstream.rest.RepositoryEnricher;
import com.atlassian.bitbucket.internal.mirroring.upstream.rest.RepositoryResource;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@Tag(name="Mirroring (Upstream)")
@UnrestrictedAccess
@Path(value="projects")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class ProjectResource {
    private final I18nService i18nService;
    private final ProjectService projectService;
    private final RepositoryEnricher repositoryEnricher;
    private final RepositoryService repositoryService;

    @Inject
    public ProjectResource(I18nService i18nService, ProjectService projectService, RepositoryEnricher repositoryEnricher, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.projectService = projectService;
        this.repositoryEnricher = repositoryEnricher;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Returns a page of repositories for a given project, enriched with a content hash", summary="Get hashes for repositories in project")
    @Parameters(value={@Parameter(description="the id of the requested project", name="projectId", in=ParameterIn.PATH), @Parameter(description="includes defaultBranchId in the response, if <code>true</code>. Default value is <code>false</code>", name="includeDefaultBranch", in=ParameterIn.QUERY, schema=@Schema(allowableValues={"true", "false"}, defaultValue="false", implementation=String.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of repositories with content hashes", paged=true, representation=RepositoryResource.EnrichedRepository.class, responseCode=200), @ResponseDoc(documentation="Mirroring is not available", restError=true, responseCode=409)})
    @GET
    @Path(value="{projectId}/repos")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllReposForProject(@BeanParam PageRequestResolver pageRequest, @PathParam(value="projectId") int projectId, @QueryParam(value="includeDefaultBranch") @DefaultValue(value="false") boolean includeDefaultBranch) {
        Page page = this.repositoryService.findByProjectId(projectId, pageRequest.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(this.repositoryEnricher.enrichPage((Page<Repository>)page, includeDefaultBranch))).build();
    }

    @Operation(description="Returns the requested project using its primary key ID.<br> Since 6.7", summary="Get project")
    @Parameter(description="the ID of the requested project", in=ParameterIn.PATH, name="projectId")
    @ResponseDocs(value={@ResponseDoc(documentation="The project with the specified ID", representation=RestProject.class, responseCode=200), @ResponseDoc(documentation="Project not found", restError=true, responseCode=404)})
    @GET
    @Path(value="{projectId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getProjectById(@PathParam(value="projectId") int projectId) {
        Project project = this.projectService.getById(projectId);
        if (project == null) {
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.mirroring.nosuchproject.byid", new Object[]{projectId}));
        }
        return ResponseFactory.ok(RestProject.REST_TRANSFORM.apply(project)).build();
    }
}

