/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryEnricher {
    private static final String CONTENT_HASH = "contentHash";
    private static final String DEFAULT_BRANCH_ID = "defaultBranchId";
    private static final String METADATA_HASH = "metadataHash";
    private static final String PROPERTIES = "properties";
    private final DmzMirrorHashService mirrorHashService;
    private final RefService refService;

    @Autowired
    public RepositoryEnricher(RefService refService, DmzMirrorHashService mirrorHashService) {
        this.mirrorHashService = mirrorHashService;
        this.refService = refService;
    }

    RestRepository enrich(Repository repository, boolean includeDefaultBranch) {
        return this.createEnricher(RepositoryEnricher.getIds(repository), includeDefaultBranch).apply(repository);
    }

    Page<RestRepository> enrichPage(Page<Repository> page, boolean includeDefaultBranch) {
        if (page.getSize() == 0) {
            return PageUtils.createEmptyPage((PageRequest)PageUtils.newRequest((int)page.getStart(), (int)page.getLimit()));
        }
        Stream<Integer> repositoryIds = page.stream().flatMap(RepositoryEnricher::getIds);
        return page.transform(this.createEnricher(repositoryIds, includeDefaultBranch));
    }

    private Map<String, Object> buildProperties(Repository repository, Map<Integer, MirrorHashes> hashesById, boolean includeDefaultBranch) {
        MirrorHashes hashes;
        int repositoryId = repository.getId();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (includeDefaultBranch) {
            properties.put(DEFAULT_BRANCH_ID, this.getDefaultBranch(repository));
        }
        if ((hashes = hashesById.get(repositoryId)) == null) {
            properties.put(CONTENT_HASH, DmzMirrorHashService.NULL_HASH);
            properties.put(METADATA_HASH, DmzMirrorHashService.NULL_HASH);
        } else {
            properties.put(CONTENT_HASH, hashes.getContent());
            properties.put(METADATA_HASH, hashes.getMetadata());
        }
        return properties;
    }

    private Function<Repository, RestRepository> createEnricher(Stream<Integer> repositoryIds, boolean includeDefaultBranch) {
        Map hashesById = this.mirrorHashService.mapHashesByRepositoryId((Set)repositoryIds.collect(MoreCollectors.toImmutableSet()));
        return repository -> {
            RestRepository rest = new RestRepository(repository);
            rest.put((Object)PROPERTIES, this.buildProperties((Repository)repository, hashesById, includeDefaultBranch));
            Repository origin = repository.getOrigin();
            RestRepository restOrigin = (RestRepository)rest.get((Object)"origin");
            while (origin != null) {
                restOrigin.put((Object)PROPERTIES, this.buildProperties(origin, hashesById, includeDefaultBranch));
                origin = origin.getOrigin();
                restOrigin = (RestRepository)restOrigin.get((Object)"origin");
            }
            return rest;
        };
    }

    private static Stream<Integer> getIds(Repository repository) {
        Repository origin = repository.getOrigin();
        if (origin == null) {
            return Stream.of(Integer.valueOf(repository.getId()));
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(repository.getId());
        do {
            ids.add(origin.getId());
        } while ((origin = origin.getOrigin()) != null);
        return ids.stream();
    }

    private String getDefaultBranch(Repository repository) {
        try {
            return this.refService.getDefaultBranch(repository).getId();
        }
        catch (NoDefaultBranchException e) {
            return e.getBranchName();
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

