/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirrorLinkService;
import com.atlassian.bitbucket.internal.mirroring.upstream.rest.RepositoryEnricher;
import com.atlassian.bitbucket.internal.mirroring.upstream.rest.RestMirroredRepositoryDescriptor;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;

@Tag(name="Mirroring (Upstream)")
@UnrestrictedAccess
@Path(value="repos")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class RepositoryResource {
    private final I18nService i18nService;
    private final MirrorLinkService mirrorLinkService;
    private final MirrorService mirrorService;
    private final NavBuilder navBuilder;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryEnricher repositoryEnricher;
    private final RepositoryService repositoryService;

    @Inject
    public RepositoryResource(I18nService i18nService, MirrorLinkService mirrorLinkService, MirrorService mirrorService, NavBuilder navBuilder, PermissionValidationService permissionValidationService, RepositoryEnricher repositoryEnricher, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.mirrorLinkService = mirrorLinkService;
        this.mirrorService = mirrorService;
        this.navBuilder = navBuilder;
        this.permissionValidationService = permissionValidationService;
        this.repositoryEnricher = repositoryEnricher;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Returns a page of repositories enriched with a content hash and default branch", summary="Get content hashes for repositories")
    @Parameter(description="includes defaultBranchId for each repository in the response, if <code>true</code>. Default value is <code>false</code>.", in=ParameterIn.QUERY, name="includeDefaultBranch", schema=@Schema(allowableValues={"true", "false"}, defaultValue="false", implementation=String.class))
    @ResponseDocs(value={@ResponseDoc(documentation="A page of repositories with content hashes and default branch", representation=EnrichedRepository.class, responseCode=200), @ResponseDoc(documentation="Mirroring is not available", restError=true, responseCode=409)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllContentHashes(@BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="includeDefaultBranch") @DefaultValue(value="false") boolean includeDefaultBranch) {
        this.permissionValidationService.validateAuthenticated();
        Page page = this.repositoryService.findAll(pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(this.repositoryEnricher.enrichPage((Page<Repository>)page, includeDefaultBranch))).build();
    }

    @Operation(description="Returns a repository enriched with a content hash and default branch", summary="Get content hash for a repository")
    @Parameters(value={@Parameter(description="the ID of the requested repository", in=ParameterIn.PATH, name="repoId"), @Parameter(description=" includes defaultBranchId in the response, if <code>true</code>. Default value is <code>false</code>.")})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository with the specified repoId", representation=EnrichedRepository.class, responseCode=200), @ResponseDoc(documentation="Repository not found", restError=true, responseCode=404)})
    @GET
    @Path(value="{repoId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getContentHashById(@PathParam(value="repoId") int repoId, @QueryParam(value="includeDefaultBranch") @DefaultValue(value="false") boolean includeDefaultBranch) {
        Repository repository = this.repositoryService.getById(repoId);
        if (repository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.notFound", new Object[]{repoId}), null);
        }
        return ResponseFactory.ok((Object)this.repositoryEnricher.enrich(repository, includeDefaultBranch)).build();
    }

    @Operation(description="Returns a page of mirrors for a repository. This resource will return <strong>all mirrors</strong> along with authorized links to the mirror's repository REST resource. To determine if a repository is available on the mirror, the returned URL needs to be called.", summary="Get mirrors for repository")
    @Parameter(description="the ID of the requested repository", in=ParameterIn.PATH, name="repoId")
    @ResponseDocs(value={@ResponseDoc(documentation="The mirrored repository descriptor", representation=RestMirroredRepositoryDescriptor.class, responseCode=200), @ResponseDoc(documentation="Mirroring is not available", restError=true, responseCode=409)})
    @GET
    @Path(value="{repoId}/mirrors")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoryMirrors(@BeanParam PageRequestResolver pageRequestResolver, @PathParam(value="repoId") int repoId, @QueryParam(value="preAuthorized") boolean preAuthorized) {
        Repository repository = this.repositoryService.getById(repoId);
        if (repository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.notFound", new Object[]{repoId}), null);
        }
        Page<MirrorServer> mirrorServerPage = this.mirrorService.findAll(pageRequestResolver.getPageRequest());
        ImmutableList.Builder restMirroredRepositoriesBuilder = new ImmutableList.Builder();
        String upstreamBaseUrl = this.navBuilder.buildBaseUrl();
        for (MirrorServer mirrorServer : mirrorServerPage.getValues()) {
            if (preAuthorized) {
                String delegateSelfLink = String.format("%s/rest/mirroring/latest/mirrors/%s/repos/%d", upstreamBaseUrl, mirrorServer.getId(), repoId);
                restMirroredRepositoriesBuilder.add((Object)new RestMirroredRepositoryDescriptor(mirrorServer, delegateSelfLink));
                continue;
            }
            String authorizedSelfLink = this.mirrorLinkService.generateRepositoryAuthorizedLink(repository, (InternalMirrorServer)mirrorServer);
            restMirroredRepositoriesBuilder.add((Object)new RestMirroredRepositoryDescriptor(mirrorServer, authorizedSelfLink));
        }
        return ResponseFactory.ok((Object)new RestPage(PageUtils.createPage((Iterable)restMirroredRepositoriesBuilder.build(), (PageRequest)pageRequestResolver.getPageRequest()))).build();
    }

    private static class RestProperties
    extends HashMap<String, String> {
        private static final String CONTENT_HASH = "contentHash";
        private static final String DEFAULT_BRANCH_ID = "defaultBranchId";
        private static final String METADATA_HASH = "metadataHash";

        private RestProperties() {
        }

        @Schema(example="457389a0b871fb61012a7351d09aefc0cf1c57c306449d4b5df4d2f381df8433")
        public String getContentHash() {
            return null;
        }

        @Schema(example="refs/heads/master")
        public String getDefaultBranchId() {
            return null;
        }

        @Schema(example="11e5cd17e8d74d84a11f2c8a6bbc6ae0a2b69059e54030f49214c94d980364c1")
        public String getMetadataHash() {
            return null;
        }

        @Override
        @Schema(hidden=true)
        public boolean isEmpty() {
            return super.isEmpty();
        }
    }

    static class EnrichedRepository
    extends RestRepository {
        EnrichedRepository() {
        }

        @Schema(implementation=RestProperties.class)
        public RestProperties getProperties() {
            return null;
        }
    }
}

