/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.Date;

@JsonSerialize
@JsonSurrogate(value=MirrorServer.class)
public class RestMirrorServer
extends RestMapEntity
implements MirrorServer {
    public static final String ID = "id";
    public static final String BASE_URL = "baseUrl";
    public static final String ENABLED = "enabled";
    public static final String LAST_SEEN_DATE = "lastSeenDate";
    public static final String NAME = "name";
    public static final String MIRROR_TYPE = "mirrorType";
    public static final String PRODUCT_VERSION = "productVersion";

    private RestMirrorServer(String id, String baseUrl, String name, MirrorType mirrorType, String productVersion, Date lastSeenDate, boolean enabled) {
        this.put(ID, id);
        this.put(BASE_URL, baseUrl);
        this.put(NAME, name);
        this.put(MIRROR_TYPE, mirrorType.getId());
        this.put(PRODUCT_VERSION, productVersion);
        this.put(LAST_SEEN_DATE, lastSeenDate);
        this.put(ENABLED, enabled);
    }

    public RestMirrorServer() {
    }

    public RestMirrorServer(MirrorServer mirror) {
        this(mirror.getId(), mirror.getBaseUrl(), mirror.getName(), mirror.getMirrorType(), mirror.getProductVersion(), mirror.getLastSeenDate(), mirror.isEnabled());
    }

    @Override
    @Schema(example="http://vietnam.example.com")
    @RequiredString(size=255)
    public String getBaseUrl() {
        return this.getStringProperty(BASE_URL);
    }

    @Override
    @Schema(example="B0F5-CS21-45C2-CCK3")
    @RequiredString(size=64)
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Override
    @NotNull
    public Date getLastSeenDate() {
        return new Date(this.getLongProperty(LAST_SEEN_DATE));
    }

    @Override
    @Schema(example="Mirror")
    @RequiredString(size=64)
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Override
    @Nonnull
    public MirrorType getMirrorType() {
        return MirrorType.fromId(this.getStringProperty(MIRROR_TYPE));
    }

    @Override
    @Schema(example="8.0.0")
    @RequiredString(size=64)
    public String getProductVersion() {
        return this.getStringProperty(PRODUCT_VERSION);
    }

    @Override
    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }
}

