/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashScheduler;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.hash.RepositoryHashAuthorizer;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.time.Duration;

@UnrestrictedAccess
@Path(value="repo-hashes")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Hidden
public class UpstreamRepositoryHashResource {
    private static final int HASH_REFRESH_DELAY = 5;
    private final I18nService i18nService;
    private final DmzMirrorHashScheduler mirrorHashScheduler;
    private final PermissionService permissionService;
    private final RepositoryHashAuthorizer repositoryHashAuthorizer;
    private final RepositoryService repositoryService;

    @Inject
    public UpstreamRepositoryHashResource(I18nService i18nService, DmzMirrorHashScheduler mirrorHashScheduler, PermissionService permissionService, RepositoryHashAuthorizer repositoryHashAuthorizer, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.mirrorHashScheduler = mirrorHashScheduler;
        this.permissionService = permissionService;
        this.repositoryHashAuthorizer = repositoryHashAuthorizer;
        this.repositoryService = repositoryService;
    }

    @POST
    @Path(value="/content/{repoId}/refresh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response refreshContentHash(@PathParam(value="repoId") int repoId) {
        this.authorize();
        Repository repository = this.repositoryService.getById(repoId);
        if (repository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.repository.notFound", new Object[]{repoId}), null);
        }
        this.mirrorHashScheduler.schedule(repository, MirrorHashType.CONTENT, Duration.ofSeconds(5L));
        return Response.ok().build();
    }

    private void authorize() {
        if (this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            return;
        }
        this.repositoryHashAuthorizer.authorize();
    }
}

