/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest.auth;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestApplicationUserWithPermissions;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestAuthenticationRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.auth.MirrorAuthenticationService;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="Mirroring (Upstream)")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@UnrestrictedAccess
@Path(value="authenticate")
public class AuthenticationResource {
    private final MirrorAuthenticationService authenticationService;
    private final I18nService i18nService;
    private final Validator validator;

    @Inject
    public AuthenticationResource(MirrorAuthenticationService authenticationService, I18nService i18nService, Validator validator) {
        this.authenticationService = authenticationService;
        this.i18nService = i18nService;
        this.validator = validator;
    }

    @Operation(description="Authenticates on behalf of a user. Used by mirrors to check the credentials supplied to them by users. If successful a user and their effective permissions are returned as follows -\n\n* For SSH credentials - all the effective user permissions are returned.\n* For all other credentials - the highest global permission is returned along with highest repository permission if repository ID is also provided in the request.\n\nCurrently only username/password, bearer token and SSH credentials are supported.", summary="Authenticate on behalf of a user")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestAuthenticationRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user for the supplied credentials and their effective permissions}.", representation=RestApplicationUserWithPermissions.class, responseCode=200), @ResponseDoc(documentation=" The currently authenticated user is not permitted to authenticate on behalf of users or authentication with the supplied user credentials failed for some reason", responseCode=401, restError=true), @ResponseDoc(documentation="If the supplied credentials are incomplete or not understood.", responseCode=400, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response authenticate(RestAuthenticationRequest authRequest) {
        ApplicationUserWithPermissions user = this.authenticationService.authenticateForUser(((RestAuthenticationRequest)((Object)ValidationUtils.validate((Validator)this.validator, (Object)((Object)authRequest), (Class[])new Class[0]))).getCredentials(), authRequest.getRepositoryId());
        if (user == null) {
            return ResponseFactory.error((Response.Status)Response.Status.UNAUTHORIZED, (String)"credentials", (String)this.i18nService.getMessage("bitbucket.mirroring.authentication.delegation.failed", new Object[]{this.i18nService.getMessage("bitbucket.mirroring.authentication.delegation.invalid.credentials", new Object[0])})).build();
        }
        return ResponseFactory.ok((Object)new RestApplicationUserWithPermissions(user)).build();
    }
}

