/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.rest.handshake;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.cluster.DmzClusterService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.rest.RestUpstreamHandshakeResponse;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirrorUserHelper;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Hidden
@UnrestrictedAccess
@Singleton
@Path(value="handshake")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class HandshakeResource {
    private final AuthenticationContext authenticationContext;
    private final DmzClusterService clusterService;
    private final I18nService i18nService;

    @Inject
    public HandshakeResource(AuthenticationContext authenticationContext, DmzClusterService clusterService, I18nService i18nService) {
        this.authenticationContext = authenticationContext;
        this.clusterService = clusterService;
        this.i18nService = i18nService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response requestHandshake() {
        if (MirrorUserHelper.isMirrorServiceUser(this.authenticationContext.getCurrentUser())) {
            return Response.ok((Object)((Object)new RestUpstreamHandshakeResponse(this.clusterService.getClusterId()))).build();
        }
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.error.notallowed", new Object[0]));
    }
}

