/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.ssh;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.MirroringConstants;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandContext;
import com.atlassian.bitbucket.ssh.command.SshCommandFactory;
import com.atlassian.bitbucket.ssh.command.SshCommandFactoryModuleDescriptor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedSshCommandFactory
implements SshCommandFactory {
    private static final Pattern PROXY_COMMAND_PATTERN = Pattern.compile("proxy\\s(\\d+)\\s((\\S+)(?:\\s+\\S+.*|$))");
    private static final Logger log = LoggerFactory.getLogger(ProxiedSshCommandFactory.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final FeatureManager featureManager;
    private final InternalMirrorService mirrorService;
    private final PluginAccessor pluginAccessor;
    private final ApplicationPropertiesService propertiesService;
    private final SecurityService securityService;
    private final UserService userService;

    public ProxiedSshCommandFactory(@Nonnull AuthenticationContext authenticationContext, @Nonnull FeatureManager featureManager, @Nonnull InternalMirrorService mirrorService, @Nonnull I18nService i18nService, @Nonnull PluginAccessor pluginAccessor, @Nonnull ApplicationPropertiesService propertiesService, @Nonnull SecurityService securityService, @Nonnull UserService userService) {
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.mirrorService = mirrorService;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.propertiesService = propertiesService;
        this.securityService = securityService;
        this.userService = userService;
    }

    @Nonnull
    public Optional<SshCommand> create(@Nonnull SshCommandContext context) {
        String command = context.getCommand();
        return this.parseProxyCommand(command).flatMap(commandMatcherAndCommandFactory -> {
            log.debug("Proxied SSH command received: \"{}\"", (Object)command);
            Matcher commandMatcher = (Matcher)commandMatcherAndCommandFactory.left();
            SshCommandFactory commandFactory = (SshCommandFactory)commandMatcherAndCommandFactory.right();
            int userId = Integer.parseInt(commandMatcher.group(1));
            String proxiedCommandAndArgs = commandMatcher.group(2);
            MirrorServer mirror = this.mirrorService.getForUser(this.authenticationContext.getCurrentUser());
            if (mirror == null || !mirror.isEnabled()) {
                String nonServiceUserName = this.authenticationContext.getCurrentUser() == null ? "<anonymous>" : this.authenticationContext.getCurrentUser().getName();
                log.warn("Invalid attempt by user \"{}\" to proxy user with id {} for SSH command \"{}\" - user \"{}\" does not correspond to a service user for an active mirror", new Object[]{nonServiceUserName, userId, command, nonServiceUserName});
                throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.ssh.proxy.permission.denied", new Object[0]));
            }
            ApplicationUser user = this.userService.getUserById(userId);
            if (user == null) {
                log.warn("Invalid attempt by mirror {} to proxy user with id {} for SSH command \"{}\" - this user is inactive or does not exist", new Object[]{this.describe(mirror), userId, proxiedCommandAndArgs});
                return Optional.empty();
            }
            String userName = user.getName();
            EscalatedSecurityContext securityContext = this.securityService.impersonating(user, String.format("Creating/running SSH command proxied by mirror %s for user \"%s\": \"%s\"", this.describe(mirror), userName, proxiedCommandAndArgs));
            SshCommand delegateSshCommand = (SshCommand)securityContext.call(() -> commandFactory.create(new SshCommandContext.Builder(proxiedCommandAndArgs, context.getStdin(), context.getStdout(), context.getStderr()).build()).orElse(null));
            if (delegateSshCommand == null) {
                log.error("Error while allowing mirror {} to proxy user \"{}\" for SSH command \"{}\" - failed to create SSH command", new Object[]{this.describe(mirror), userName, proxiedCommandAndArgs});
                return Optional.empty();
            }
            log.debug("Executing SSH command proxied by mirror {} for user \"{}\": \"{}\"", new Object[]{this.describe(mirror), userName, proxiedCommandAndArgs});
            return Optional.of(new RunAsCommand(delegateSshCommand, securityContext));
        });
    }

    public boolean supports(@Nonnull String command) {
        return this.parseProxyCommand(command).isPresent();
    }

    private String describe(@Nonnull MirrorServer mirror) {
        return "[" + mirror.getBaseUrl() + "]#" + mirror.getId();
    }

    private Optional<SshCommandFactory> getSupportingModuleFor(String commandAndArgs) {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SshCommandFactoryModuleDescriptor.class)).filter(m -> m.supports(commandAndArgs)).findFirst();
    }

    private boolean isSupportedSshProxyCommand(String command) {
        return MirroringConstants.SUPPORTED_SSH_PROXY_COMMANDS.contains(command.toLowerCase(Locale.ROOT));
    }

    private Optional<Pair<Matcher, SshCommandFactory>> parseProxyCommand(@Nonnull String command) {
        boolean mirroringEnabled = this.featureManager.isEnabled((Feature)StandardFeature.SMART_MIRRORS);
        if (!mirroringEnabled) {
            log.debug("Mirroring has been disabled on this server. Unable to process proxy command \"{}\"", (Object)command);
            return Optional.empty();
        }
        boolean proxiedSshWritesEnabled = this.propertiesService.getPluginProperty("plugin.mirroring.ssh.upstream.proxying.enabled", true);
        if (!proxiedSshWritesEnabled) {
            log.info("Accepting proxied write commands over SSH has been disabled on this upstream. Unable to process proxy command \"{}\"", (Object)command);
            return Optional.empty();
        }
        Matcher matcher = PROXY_COMMAND_PATTERN.matcher(command);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String proxiedCommandAndArgs = matcher.group(2);
        String proxiedCommand = matcher.group(3);
        if (!this.isSupportedSshProxyCommand(proxiedCommand)) {
            log.warn("Proxying of SSH command is unsupported: \"{}\"", (Object)proxiedCommandAndArgs);
            return Optional.empty();
        }
        Optional<SshCommandFactory> commandFactory = this.getSupportingModuleFor(proxiedCommandAndArgs);
        if (!commandFactory.isPresent()) {
            log.warn("No module found to support proxied SSH command: \"{}\"", (Object)proxiedCommandAndArgs);
            return Optional.empty();
        }
        return Optional.of(Pair.pair((Object)matcher, (Object)commandFactory.get()));
    }

    private static class RunAsCommand
    implements SshCommand {
        private final SshCommand delegate;
        private final EscalatedSecurityContext securityContext;

        private RunAsCommand(SshCommand delegate, EscalatedSecurityContext securityContext) {
            this.delegate = delegate;
            this.securityContext = securityContext;
        }

        public void cancel() {
            this.securityContext.call(() -> {
                this.delegate.cancel();
                return null;
            });
        }

        public int run() throws IOException {
            return (Integer)this.securityContext.call(() -> ((SshCommand)this.delegate).run());
        }
    }
}

