/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequestState;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirroringRequestSearchRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirroringRequestService;
import com.atlassian.bitbucket.internal.mirroring.upstream.SmartMirroringFeature;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.web.util.UriTemplate;

@UnrestrictedAccess
public class MirrorsAdminServlet
extends HttpServlet {
    private static final String TEMPLATE_NAMESPACE = "bitbucketPluginMirroringUpstream.internal.page.adminReact.mirroringServerSide";
    private static final String VIEW_DASHBOARD = "bitbucketPluginMirroringUpstream.internal.page.adminReact.mirroringServerSide.dashboard";
    private static final String VIEW_AUTHORIZE = "bitbucketPluginMirroringUpstream.internal.page.adminReact.mirroringServerSide.authorize";
    private static final String VIEW_MIRROR = "bitbucketPluginMirroringUpstream.internal.page.adminReact.mirroringServerSide.mirror";
    private static final String VIEW_UNAVAILABLE = "bitbucketPluginMirroringUpstream.internal.page.adminReact.mirroringServerSide.unavailable";
    private static final UriTemplate URI_TEMPLATE_MIRROR = new UriTemplate("/{type}/{mirrorId}");
    private static final UriTemplate URI_TEMPLATE_AUTHORIZE = new UriTemplate("/{type}/{mirrorId}/authorize/{requestId}");
    private static final UriTemplate URI_TEMPLATE_AUTHORIZE_REDIRECT = new UriTemplate("/{type}/{mirrorId}/authorize");
    private final MirrorService mirrorService;
    private final SmartMirroringFeature mirroringFeature;
    private final MirroringRequestService mirroringRequestService;
    private final NavBuilder navBuilder;
    private final PermissionValidationService permissionValidationService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final WebSudoManager webSudoManager;

    public MirrorsAdminServlet(MirrorService mirrorService, SmartMirroringFeature mirroringFeature, MirroringRequestService mirroringRequestService, NavBuilder navBuilder, PermissionValidationService permissionValidationService, SoyTemplateRenderer soyTemplateRenderer, WebSudoManager webSudoManager) {
        this.mirrorService = mirrorService;
        this.mirroringFeature = mirroringFeature;
        this.mirroringRequestService = mirroringRequestService;
        this.navBuilder = navBuilder;
        this.permissionValidationService = permissionValidationService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.webSudoManager.willExecuteWebSudoRequest(req);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String pathInfo = req.getPathInfo();
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        boolean featureIsEnabled = this.mirroringFeature.isEnabled();
        if (featureIsEnabled && URI_TEMPLATE_MIRROR.matches(pathInfo)) {
            Map templateVariables = URI_TEMPLATE_MIRROR.match(pathInfo);
            String id = (String)templateVariables.get("mirrorId");
            MirrorServer mirror = this.mirrorService.getById(id);
            if (mirror == null) {
                resp.sendError(404);
                return;
            }
            ImmutableMap<String, Object> mirrorMap = this.createMirrorMap(mirror);
            builder.put((Object)"activeMirror", mirrorMap);
            this.render(resp, VIEW_MIRROR, (Map<String, Object>)builder.build());
        } else if (featureIsEnabled && URI_TEMPLATE_AUTHORIZE.matches(pathInfo)) {
            Map templateVariables = URI_TEMPLATE_AUTHORIZE.match(pathInfo);
            try {
                int requestId = Integer.parseInt((String)templateVariables.get("requestId"));
                MirroringRequest mirror = this.mirroringRequestService.getById(requestId);
                if (mirror == null || mirror.getState() != MirroringRequestState.PENDING) {
                    resp.sendError(404);
                    return;
                }
                ImmutableMap<String, Object> mirrorMap = this.createMirrorMap(mirror);
                builder.put((Object)"activeMirror", mirrorMap);
                this.render(resp, VIEW_AUTHORIZE, (Map<String, Object>)builder.build());
            }
            catch (NumberFormatException e) {
                resp.sendError(400);
            }
        } else if (featureIsEnabled && URI_TEMPLATE_AUTHORIZE_REDIRECT.matches(pathInfo)) {
            Map templateVariables = URI_TEMPLATE_AUTHORIZE_REDIRECT.match(pathInfo);
            MirroringRequestSearchRequest searchRequest = new MirroringRequestSearchRequest.Builder().state(MirroringRequestState.PENDING).mirrorId((String)templateVariables.get("mirrorId")).build();
            Optional<Integer> requestId = this.mirroringRequestService.findAll(searchRequest, PageUtils.newRequest((int)0, (int)1)).stream().findAny().map(MirroringRequest::getId);
            if (requestId.isPresent()) {
                templateVariables.put("requestId", String.valueOf(requestId.get()));
                resp.sendRedirect(this.navBuilder.admin().mirrors().buildRelative() + String.valueOf(URI_TEMPLATE_AUTHORIZE.expand(templateVariables)));
            } else {
                resp.sendError(404);
            }
        } else if (featureIsEnabled) {
            PageRequest request = PageUtils.newRequest((int)0, (int)0x100000);
            Page<MirroringRequest> pendingRequests = this.mirroringRequestService.findAll(new MirroringRequestSearchRequest.Builder().state(MirroringRequestState.PENDING).build(), request);
            Page<MirrorServer> mirrors = this.mirrorService.findAll(request);
            builder.put((Object)"pendingMirrors", (Object)pendingRequests.stream().map(this::createMirrorMap).toArray());
            builder.put((Object)"mirrors", (Object)mirrors.stream().map(this::createMirrorMap).toArray());
            builder.put((Object)"available", (Object)featureIsEnabled);
            this.render(resp, VIEW_DASHBOARD, (Map<String, Object>)builder.build());
        } else {
            this.render(resp, VIEW_UNAVAILABLE, (Map<String, Object>)builder.build());
        }
    }

    private ImmutableMap<String, Object> createMirrorMap(MirroringRequest request) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)request.getMirrorId());
        builder.put((Object)"baseUrl", (Object)request.getBaseUrl());
        builder.put((Object)"name", (Object)request.getMirrorName());
        builder.put((Object)"mirrorType", (Object)request.getMirrorType().getId());
        builder.put((Object)"productVersion", (Object)request.getProductVersion());
        builder.put((Object)"date", (Object)request.getCreatedDate());
        builder.put((Object)"authorization", (Object)request.getState().getId());
        builder.put((Object)"enabled", (Object)false);
        builder.put((Object)"requestId", (Object)Objects.requireNonNull(request.getId(), "Mirror request ID can not be null"));
        return builder.build();
    }

    private ImmutableMap<String, Object> createMirrorMap(MirrorServer mirror) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)mirror.getId());
        builder.put((Object)"baseUrl", (Object)mirror.getBaseUrl());
        builder.put((Object)"name", (Object)mirror.getName());
        builder.put((Object)"mirrorType", (Object)mirror.getMirrorType().getId());
        builder.put((Object)"productVersion", (Object)mirror.getProductVersion());
        builder.put((Object)"date", (Object)mirror.getLastSeenDate());
        builder.put((Object)"authorization", (Object)MirroringRequestState.ACCEPTED.getId());
        builder.put((Object)"enabled", (Object)mirror.isEnabled());
        return builder.build();
    }

    private void render(HttpServletResponse resp, String templateName, Map<String, Object> data) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), "com.atlassian.bitbucket.server.bitbucket-mirroring-upstream:mirror-soy-templates", templateName, data);
        }
        catch (SoyException e) {
            Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), IOException.class);
            throw new ServletException((Throwable)e);
        }
    }
}

