/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.webhook;

import com.atlassian.bitbucket.dmz.webhook.MirrorScope;
import com.atlassian.bitbucket.internal.mirroring.webhook.WebHookEventId;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookCreateRequest;
import com.atlassian.webhooks.WebhookDeleteRequest;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.WebhookService;
import io.atlassian.util.concurrent.LazyReference;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorWebhookRegistry {
    private static final Logger log = LoggerFactory.getLogger(MirrorWebhookRegistry.class);
    private static final String WEBHOOK_EVENTS_URL = "/rest/mirroring/latest/webhookEvents";
    private static final String WEBHOOK_NAME_PREFIX = "mirror-webhook-";
    private final TransactionTemplate transactionTemplate;
    private final LazyReference<Set<WebhookEvent>> webhookEvents;
    private final WebhookService webhookService;

    @Autowired
    public MirrorWebhookRegistry(final WebhookService webhookService, TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
        this.webhookEvents = new LazyReference<Set<WebhookEvent>>(this){

            protected Set<WebhookEvent> create() {
                Set webhookEventNames = Arrays.stream(WebHookEventId.values()).map(WebHookEventId::getValue).collect(Collectors.toSet());
                return (Set)webhookService.getEvents().stream().filter(w -> webhookEventNames.contains(w.getId())).collect(MoreCollectors.toImmutableSet());
            }
        };
        this.webhookService = webhookService;
    }

    public void register(@Nonnull String baseUrl, @Nonnull String mirrorId) {
        Objects.requireNonNull(baseUrl, "baseUrl");
        Objects.requireNonNull(mirrorId, "mirrorId");
        String name = MirrorWebhookRegistry.getWebhookName(mirrorId);
        this.transactionTemplate.execute(() -> {
            this.webhookService.delete(((WebhookDeleteRequest.Builder)WebhookDeleteRequest.builder().name(name)).build());
            Webhook webhook = this.webhookService.create(((WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)((WebhookCreateRequest.Builder)WebhookCreateRequest.builder().name(name)).event((Iterable)this.webhookEvents.get())).scope((WebhookScope)MirrorScope.MIRROR)).url(baseUrl + WEBHOOK_EVENTS_URL)).configuration("bitbucket-mirror-id", mirrorId)).build());
            log.debug("Registered webhook for mirror with ID {}", (Object)mirrorId);
            return webhook;
        });
    }

    public void unregister(@Nonnull String mirrorId) {
        Objects.requireNonNull(mirrorId, "mirrorId");
        this.webhookService.delete(((WebhookDeleteRequest.Builder)WebhookDeleteRequest.builder().name(MirrorWebhookRegistry.getWebhookName(mirrorId))).build());
        log.debug("Unregistered webhook for mirror with ID {}", (Object)mirrorId);
    }

    private static String getWebhookName(String mirrorId) {
        return WEBHOOK_NAME_PREFIX + mirrorId;
    }
}

