/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream.webhook;

import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.internal.mirroring.upstream.JwtGenerator;
import com.atlassian.httpclient.api.Request;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookInvocation;
import com.atlassian.webhooks.WebhookRequestEnricher;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorWebhookSigner
implements WebhookRequestEnricher {
    public static final String MIRROR_WEBHOOK_CONFIG_KEY = "bitbucket-mirror-id";
    private static final Logger log = LoggerFactory.getLogger(MirrorWebhookSigner.class);
    private static final int WEIGHT = 1000;
    private final JwtGenerator jwtGenerator;
    private final InternalMirrorService mirrorService;

    @Autowired
    public MirrorWebhookSigner(JwtGenerator jwtGenerator, InternalMirrorService mirrorService) {
        this.jwtGenerator = jwtGenerator;
        this.mirrorService = mirrorService;
    }

    public void enrich(@Nonnull WebhookInvocation webhookInvocation) {
        Objects.requireNonNull(webhookInvocation, "webhookInvocation");
        Webhook webhook = webhookInvocation.getWebhook();
        String mirrorId = (String)webhook.getConfiguration().get(MIRROR_WEBHOOK_CONFIG_KEY);
        if (StringUtils.isNotEmpty((CharSequence)mirrorId)) {
            this.maybeSign(webhookInvocation, mirrorId, webhook);
        }
    }

    public int getWeight() {
        return 1000;
    }

    private void maybeSign(WebhookInvocation webhookInvocation, String mirrorId, Webhook webhook) {
        InternalMirrorServer mirrorServer = this.mirrorService.getById(mirrorId);
        if (mirrorServer != null) {
            String relativeUrl = StringUtils.remove((String)webhook.getUrl(), (String)StringUtils.stripEnd((String)mirrorServer.getBaseUrl(), (String)"/"));
            String jwt = this.jwtGenerator.generate(mirrorServer, relativeUrl, Request.Method.POST.name());
            webhookInvocation.getRequestBuilder().header("Authorization", "JWT " + jwt);
        } else {
            log.warn("Could not sign the mirror webhook request as the mirror with ID {} doesn't exist", (Object)mirrorId);
        }
    }
}

