/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.webhook;

import com.atlassian.bitbucket.internal.mirroring.rest.RestUnknownEntity;
import jakarta.annotation.Nonnull;
import java.util.Optional;

public enum WebHookEventId {
    PROJECT_CREATED("project:created"),
    PROJECT_DELETED("project:deleted"),
    PROJECT_MODIFIED("project:modified"),
    REPOSITORY_CREATED("repo:created"),
    REPOSITORY_DELETED("repo:deleted"),
    REPOSITORY_MODIFIED("repo:modified"),
    REPOSITORY_REFS_CHANGED("repo:refs_changed"),
    REPOSITORY_DEFAULT_BRANCH_MODIFIED("repo:default_branch_modified");

    private final String id;

    private WebHookEventId(String id) {
        this.id = id;
    }

    @Nonnull
    public String getValue() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    @Nonnull
    public static Optional<WebHookEventId> fromEntity(@Nonnull RestUnknownEntity unknownEntity) {
        String eventKey;
        Object eventKeyValue = unknownEntity.get("eventKey");
        String string = eventKey = eventKeyValue instanceof String ? (String)eventKeyValue : null;
        if (eventKey == null) {
            return Optional.empty();
        }
        for (WebHookEventId webHookEventId : WebHookEventId.values()) {
            if (!webHookEventId.getValue().equals(eventKey)) continue;
            return Optional.of(webHookEventId);
        }
        return Optional.empty();
    }
}

