/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import net.java.ao.DisposableDataSource;

public class H2VersionUtil {
    private static final AtomicReference<Boolean> H2_LATEST_2_1_X = new AtomicReference();

    public H2VersionUtil(DisposableDataSource dataSource) {
        if (H2_LATEST_2_1_X.get() == null) {
            H2_LATEST_2_1_X.set(this.getH2VersionFlag(dataSource));
        }
    }

    private boolean getH2VersionFlag(DisposableDataSource dataSource) {
        boolean bl;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                int majorVersion = connection.getMetaData().getDatabaseMajorVersion();
                boolean bl2 = bl = majorVersion >= 2;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean isH2Latest2_1_X() {
        return H2_LATEST_2_1_X.get();
    }
}

