/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit.graph;

import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalContext;
import com.atlassian.bitbucket.commit.graph.TraversalStatus;
import com.atlassian.bitbucket.commit.graph.TraversalSummary;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.List;

public class BatchingTraversalCallback
extends TraversalCallback {
    private final List<TraversalCallback> delegates;
    private final List<TraversalCallback> activeDelegates;

    public BatchingTraversalCallback(List<? extends TraversalCallback> delegates) {
        this.delegates = ImmutableList.copyOf(delegates);
        this.activeDelegates = Lists.newArrayList(this.delegates);
    }

    public void onEnd(@Nonnull TraversalSummary summary) {
        for (TraversalCallback delegate : this.delegates) {
            delegate.onEnd(summary);
        }
    }

    public TraversalStatus onNode(@Nonnull CommitGraphNode node) {
        Iterator<TraversalCallback> it = this.activeDelegates.iterator();
        while (it.hasNext()) {
            if (it.next().onNode(node) != TraversalStatus.FINISH) continue;
            it.remove();
        }
        return this.activeDelegates.isEmpty() ? TraversalStatus.FINISH : TraversalStatus.CONTINUE;
    }

    public void onStart(@Nonnull TraversalContext context) {
        for (TraversalCallback delegate : this.delegates) {
            delegate.onStart(context);
        }
    }
}

