/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.AbstractContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.ContentTreeSummary;
import com.atlassian.bitbucket.content.DirectoryRevision;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimpleDirectoryRevision;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class DirectoryRevisionContentTreeCallback
extends AbstractContentTreeCallback {
    private final String path;
    private final String commitId;
    private final List<ContentTreeNode> nodes;
    private DirectoryRevision revision;

    public DirectoryRevisionContentTreeCallback(@Nullable String path, @Nonnull String commitId) {
        this.path = path;
        this.commitId = Objects.requireNonNull(commitId, "commitId");
        this.nodes = Lists.newArrayList();
    }

    public void onEnd(@Nonnull ContentTreeSummary summary) throws IOException {
        this.revision = new SimpleDirectoryRevision((Path)new SimplePath((CharSequence)this.path), this.commitId, (Page<ContentTreeNode>)PageUtils.createPage(this.nodes, (boolean)summary.isLastPage(), (PageRequest)summary.getPageRequest()));
    }

    public boolean onTreeNode(@Nonnull ContentTreeNode node) throws IOException {
        this.nodes.add(node);
        return true;
    }

    @Nonnull
    public DirectoryRevision getDirectoryRevision() {
        return this.revision;
    }
}

