/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SimpleBlame
implements Blame {
    private final Person author;
    private final Date authorTimestamp;
    private final Person committer;
    private final Date committerTimestamp;
    private final String commitId;
    private final String displayCommitId;
    private final String fileName;
    private final int lineNumber;
    private final int spannedLines;

    private SimpleBlame(Builder builder) {
        this.author = builder.author;
        this.authorTimestamp = builder.authorTimestamp;
        this.committer = builder.committer;
        this.committerTimestamp = builder.committerTimestamp;
        this.commitId = builder.commitId;
        this.displayCommitId = builder.displayCommitId;
        this.fileName = builder.fileName;
        this.lineNumber = builder.lineNumber;
        this.spannedLines = builder.spannedLines;
    }

    @Nonnull
    public Person getAuthor() {
        return this.author;
    }

    @Nonnull
    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    @Nonnull
    public Person getCommitter() {
        return this.committer;
    }

    @Nonnull
    public Date getCommitterTimestamp() {
        return this.committerTimestamp;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public String getCommitDisplayId() {
        return this.displayCommitId;
    }

    @Nonnull
    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getSpannedLines() {
        return this.spannedLines;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.lineNumber);
        if (this.spannedLines > 1) {
            builder.append("-").append(this.lineNumber + this.spannedLines - 1);
        }
        builder.append(":").append(this.commitId).append(" ").append(this.author).append(" ").append(this.authorTimestamp).append(" (").append(this.fileName).append(")");
        return builder.toString();
    }

    public static final class Builder
    extends BuilderSupport {
        private Person author;
        private Date authorTimestamp;
        private Person committer;
        private Date committerTimestamp;
        private String commitId;
        private String displayCommitId;
        private String fileName;
        private int lineNumber;
        private int spannedLines;

        public Builder() {
        }

        public Builder(@Nonnull Blame blame) {
            this.author = Objects.requireNonNull(blame, "blame").getAuthor();
            this.authorTimestamp = blame.getAuthorTimestamp();
            this.committer = blame.getCommitter();
            this.committerTimestamp = blame.getCommitterTimestamp();
            this.commitId = blame.getCommitId();
            this.displayCommitId = blame.getCommitDisplayId();
            this.fileName = blame.getFileName();
            this.lineNumber = blame.getLineNumber();
            this.spannedLines = blame.getSpannedLines();
        }

        @Nonnull
        public Builder author(@Nonnull Person value) {
            this.author = Objects.requireNonNull(value, "author");
            return this;
        }

        @Nonnull
        public Builder authorTimestamp(@Nonnull Date value) {
            this.authorTimestamp = Objects.requireNonNull(value, "authorTimestamp");
            return this;
        }

        @Nonnull
        public SimpleBlame build() {
            Preconditions.checkArgument((this.lineNumber > 0 ? 1 : 0) != 0, (Object)"Line numbers begin at 1 and are required");
            Preconditions.checkArgument((this.author != null && this.author.getName() != null && this.authorTimestamp != null ? 1 : 0) != 0, (Object)"Author information (name and timestamp) is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.commitId), (Object)"A commit hash is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.fileName), (Object)"A filename is required");
            if (this.displayCommitId == null) {
                this.displayCommitId = StringUtils.substring((String)this.commitId, (int)0, (int)11);
            }
            if (this.spannedLines < 1) {
                this.spannedLines = 1;
            }
            return new SimpleBlame(this);
        }

        @Nonnull
        public Builder committer(@Nonnull Person value) {
            this.committer = Objects.requireNonNull(value, "committer");
            return this;
        }

        @Nonnull
        public Builder committerTimestamp(@Nonnull Date value) {
            this.committerTimestamp = Objects.requireNonNull(value, "committerTimestamp");
            return this;
        }

        @Nonnull
        public Builder commitId(@Nonnull String value) {
            this.commitId = Builder.requireNonBlank((String)value, (String)"commitId");
            return this;
        }

        @Nonnull
        public Builder fileName(@Nonnull String value) {
            this.fileName = Builder.requireNonBlank((String)value, (String)"fileName");
            return this;
        }

        @Nonnull
        public Builder lineNumber(int value) {
            this.lineNumber = value;
            return this;
        }

        @Nonnull
        public Builder spannedLines(int value) {
            this.spannedLines = value;
            return this;
        }
    }
}

