/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.Conflict;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.property.SimplePropertySupport;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleChange
extends SimplePropertySupport
implements Change {
    private final Conflict conflict;
    private final String contentId;
    private final String fromContentId;
    private final Boolean executable;
    private final ContentTreeNode.Type nodeType;
    private final Path path;
    private final int percentUnchanged;
    private final Boolean srcExecutable;
    private final Path srcPath;
    private final ChangeType type;

    private SimpleChange(Builder builder) {
        super((SimplePropertySupport.AbstractPropertyBuilder)builder);
        this.conflict = builder.conflict;
        this.contentId = builder.contentId;
        this.fromContentId = builder.fromContentId;
        this.executable = builder.executable;
        this.nodeType = Objects.requireNonNull(builder.nodeType, "nodeType");
        this.path = Objects.requireNonNull(builder.path, "path");
        this.percentUnchanged = builder.percentUnchanged;
        this.srcExecutable = builder.srcExecutable;
        this.srcPath = builder.srcPath;
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SimpleChange) {
            SimpleChange that = (SimpleChange)((Object)o);
            return com.google.common.base.Objects.equal((Object)this.getPath(), (Object)that.getPath()) && com.google.common.base.Objects.equal((Object)this.getSrcPath(), (Object)that.getSrcPath());
        }
        return false;
    }

    public Conflict getConflict() {
        return this.conflict;
    }

    public String getContentId() {
        return this.contentId;
    }

    public Boolean getExecutable() {
        return this.executable;
    }

    public String getFromContentId() {
        return this.fromContentId;
    }

    @Nonnull
    public ContentTreeNode.Type getNodeType() {
        return this.nodeType;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public int getPercentUnchanged() {
        return this.percentUnchanged;
    }

    public Boolean getSrcExecutable() {
        return this.srcExecutable;
    }

    public Path getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public ChangeType getType() {
        return this.type;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getPath(), this.getSrcPath()});
    }

    public String toString() {
        return "SimpleChange{path='" + String.valueOf(this.getPath()) + "', srcPath='" + String.valueOf(this.getSrcPath()) + "', type=" + String.valueOf(this.getType()) + "}";
    }

    public static final class Builder
    extends SimplePropertySupport.AbstractPropertyBuilder<Builder> {
        private Conflict conflict;
        private String contentId;
        private String fromContentId;
        private Boolean executable;
        private ContentTreeNode.Type nodeType;
        private Path path;
        private int percentUnchanged;
        private Boolean srcExecutable;
        private Path srcPath;
        private ChangeType type;

        public Builder() {
            this.nodeType = ContentTreeNode.Type.FILE;
            this.percentUnchanged = -1;
        }

        public Builder(@Nonnull Change change) {
            super((PropertySupport)change);
            this.conflict = change.getConflict();
            this.contentId = change.getContentId();
            this.fromContentId = change.getFromContentId();
            this.executable = change.getExecutable();
            this.nodeType = change.getNodeType();
            this.path = change.getPath();
            this.percentUnchanged = change.getPercentUnchanged();
            this.srcExecutable = change.getSrcExecutable();
            this.srcPath = change.getSrcPath();
            this.type = change.getType();
        }

        public SimpleChange build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"A type is required");
            return new SimpleChange(this);
        }

        public Builder conflict(Conflict value) {
            this.conflict = value;
            return this;
        }

        public Builder contentId(String value) {
            this.contentId = value;
            return this;
        }

        public Builder executable(Boolean value) {
            this.executable = value;
            return this;
        }

        public Builder fromContentId(String value) {
            this.fromContentId = value;
            return this;
        }

        public Builder nodeType(@Nonnull ContentTreeNode.Type value) {
            this.nodeType = Objects.requireNonNull(value, "nodeType");
            return this;
        }

        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Objects.requireNonNull(value, "path")));
        }

        public Builder path(@Nonnull Path value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }

        public Builder percentUnchanged(int value) {
            this.percentUnchanged = value;
            return this;
        }

        public Builder srcExecutable(Boolean value) {
            this.srcExecutable = value;
            return this;
        }

        public Builder srcPath(String value) {
            if (value == null) {
                this.srcPath = null;
                return this;
            }
            return this.srcPath((Path)new SimplePath((CharSequence)value));
        }

        public Builder srcPath(Path value) {
            this.srcPath = value;
            return this;
        }

        public Builder type(@Nonnull ChangeType value) {
            this.type = Objects.requireNonNull(value, "type");
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

