/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.ConflictChange;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleConflictChange
implements ConflictChange {
    private final Path path;
    private final Path srcPath;
    private final ChangeType type;

    private SimpleConflictChange(ChangeType type, Path path, Path srcPath) {
        this.path = Objects.requireNonNull(path, "path");
        this.srcPath = srcPath;
        this.type = Objects.requireNonNull(type, "type");
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public Path getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public ChangeType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(this.getType()).append("] ");
        if (this.getSrcPath() != null) {
            builder.append(this.getSrcPath()).append(" -> ");
        }
        return builder.append(this.getPath()).toString();
    }

    public static class Builder {
        private Path path;
        private Path srcPath;
        private ChangeType type;

        public Builder() {
        }

        public Builder(ConflictChange change) {
            this.path = change.getPath();
            this.srcPath = change.getSrcPath();
            this.type = change.getType();
        }

        public SimpleConflictChange build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"A type is required");
            return new SimpleConflictChange(this.type, this.path, this.srcPath);
        }

        public Builder path(Path value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }

        public Builder path(String value) {
            return this.path((Path)new SimplePath((CharSequence)Objects.requireNonNull(value, "path")));
        }

        public Builder srcPath(Path value) {
            this.srcPath = value;
            return this;
        }

        public Builder srcPath(String value) {
            return this.srcPath((Path)(value == null ? null : new SimplePath((CharSequence)value)));
        }

        public Builder type(ChangeType value) {
            this.type = Objects.requireNonNull(value, "type");
            return this;
        }
    }
}

