/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.content.DiffSegment;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;

public class SimpleDiffHunk
implements DiffHunk {
    private final String context;
    private final int destinationLine;
    private final int destinationSpan;
    private final List<DiffSegment> segments;
    private final int sourceLine;
    private final int sourceSpan;
    private final boolean truncated;

    private SimpleDiffHunk(Builder builder) {
        this.context = builder.context;
        this.destinationLine = builder.destinationLine;
        this.destinationSpan = builder.destinationSpan;
        this.segments = builder.segments.build();
        this.sourceLine = builder.sourceLine;
        this.sourceSpan = builder.sourceSpan;
        this.truncated = builder.truncated;
    }

    @Nonnull
    public Optional<String> getContext() {
        return Optional.ofNullable(this.context);
    }

    public int getDestinationLine() {
        return this.destinationLine;
    }

    public int getDestinationSpan() {
        return this.destinationSpan;
    }

    @Nonnull
    public List<DiffSegment> getSegments() {
        return this.segments;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public int getSourceSpan() {
        return this.sourceSpan;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final class Builder {
        private String context;
        private int destinationLine;
        private int destinationSpan;
        private ImmutableList.Builder<DiffSegment> segments = ImmutableList.builder();
        private int sourceLine;
        private int sourceSpan;
        private boolean truncated;

        public Builder() {
        }

        public Builder(DiffHunk hunk) {
            this();
            this.destinationLine = hunk.getDestinationLine();
            this.destinationSpan = hunk.getDestinationSpan();
            this.sourceLine = hunk.getSourceLine();
            this.sourceSpan = hunk.getSourceSpan();
            this.truncated = hunk.isTruncated();
            this.segments.addAll((Iterable)hunk.getSegments());
        }

        @Nonnull
        public SimpleDiffHunk build() {
            return new SimpleDiffHunk(this);
        }

        @Nonnull
        public Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        @Nonnull
        public Builder destinationLine(int value) {
            this.destinationLine = value;
            return this;
        }

        @Nonnull
        public Builder destinationSpan(int value) {
            this.destinationSpan = value;
            return this;
        }

        @Nonnull
        public Builder segment(@Nonnull DiffSegment value) {
            this.segments.add((Object)value);
            return this;
        }

        @Nonnull
        public Builder segments(@Nonnull DiffSegment value, DiffSegment ... values) {
            this.segments.add((Object)value).add((Object[])values);
            return this;
        }

        @Nonnull
        public Builder segments(@Nullable Iterable<DiffSegment> value) {
            if (value != null) {
                this.segments.addAll(value);
            }
            return this;
        }

        @Nonnull
        public Builder sourceLine(int value) {
            this.sourceLine = value;
            return this;
        }

        @Nonnull
        public Builder sourceSpan(int value) {
            this.sourceSpan = value;
            return this;
        }

        @Nonnull
        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }
    }
}

