/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.Directory;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimpleDirectory
extends Directory {
    private final String contentId;
    private final Path path;

    private SimpleDirectory(Builder builder) {
        this.contentId = builder.contentId;
        this.path = builder.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleDirectory) {
            SimpleDirectory d = (SimpleDirectory)((Object)o);
            return this.getPath().equals((Object)d.getPath()) && com.google.common.base.Objects.equal((Object)this.getContentId(), (Object)d.getContentId());
        }
        return false;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getPath(), this.getContentId()});
    }

    public String toString() {
        return "SimpleDirectory{path='" + String.valueOf(this.path) + "', contentId='" + this.contentId + "'}";
    }

    public static class Builder {
        private String contentId;
        private Path path;

        public Builder() {
        }

        public Builder(@Nonnull Directory directory) {
            this.contentId = Objects.requireNonNull(directory, "directory").getContentId();
            this.path = directory.getPath();
        }

        @Nonnull
        public SimpleDirectory build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required.");
            return new SimpleDirectory(this);
        }

        @Nonnull
        public Builder contentId(@Nullable String value) {
            this.contentId = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull Path value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Objects.requireNonNull(value, "path")));
        }
    }
}

