/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;

public abstract class AbstractCommandInputOutputHandler<T>
extends BaseCommandHandler
implements CommandInputHandler,
CommandOutputHandler<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private OutputStream input;

    public void process(@Nonnull OutputStream input) throws IOException {
        this.input = input;
        this.latch.countDown();
    }

    public void process(@Nonnull InputStream output) throws IOException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return;
        }
        this.process(this.input, output);
    }

    public void complete() {
    }

    protected abstract void process(@Nonnull OutputStream var1, @Nonnull InputStream var2) throws IOException;
}

