/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.ByteBufferInputStream;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.UniversalDetector;
import org.mozilla.universalchardet.prober.UTF8Prober;

public class ContentDetectionUtils {
    public static final float HIGH_CONFIDENCE_THRESHOLD = 0.95f;

    @Nullable
    public static String detectContentType(@Nonnull ByteBuffer buffer, @Nullable String path) {
        try {
            return ContentDetectionUtils.detectContentType(new ByteBufferInputStream(Objects.requireNonNull(buffer, "buffer")), path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed reading from ByteBuffer", e);
        }
    }

    @Nullable
    public static String detectContentType(@Nonnull InputStream stream, @Nullable String path) throws IOException {
        String type = URLConnection.guessContentTypeFromStream(Objects.requireNonNull(stream, "stream"));
        if (StringUtils.isNotBlank((CharSequence)path)) {
            if (type == null) {
                type = URLConnection.guessContentTypeFromName(path);
            } else if ("application/xml".equals(type)) {
                String pathType = URLConnection.guessContentTypeFromName(path);
                if (StringUtils.isNotBlank((CharSequence)pathType) && pathType.endsWith("+xml")) {
                    type = pathType;
                }
            } else if ("audio/x-wav".equals(type) && path.contains(".webp")) {
                type = "image/webp";
            }
        }
        return type;
    }

    @Nullable
    public static String detectEncoding(@Nonnull ByteBuffer buffer) {
        if (Objects.requireNonNull(buffer, "buffer").remaining() < 4) {
            return null;
        }
        if (buffer.hasArray()) {
            return ContentDetectionUtils.detectWithUniversalDetector(buffer.array(), buffer.position(), buffer.remaining());
        }
        byte[] buf = ContentDetectionUtils.copyBuffer(buffer);
        return ContentDetectionUtils.detectEncoding(buf);
    }

    @Nullable
    public static String detectEncoding(@Nonnull InputStream stream, int bufferSize) throws IOException {
        int totalBytesRead;
        int read;
        Objects.requireNonNull(stream, "stream");
        Preconditions.checkArgument((boolean)stream.markSupported(), (Object)"Encoding detection requires a stream which supports mark/reset.");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Encoding detection requires a positive buffer size.");
        if (bufferSize < 4) {
            return null;
        }
        UniversalDetector detector = new UniversalDetector(null);
        byte[] buf = new byte[bufferSize];
        stream.mark(buf.length);
        for (totalBytesRead = 0; totalBytesRead < buf.length && !detector.isDone() && (read = stream.read(buf, totalBytesRead, buf.length - totalBytesRead)) > 0; totalBytesRead += read) {
            detector.handleData(buf, totalBytesRead, read);
        }
        stream.reset();
        detector.dataEnd();
        String charset = ContentDetectionUtils.getDetectedCharset(detector);
        if (Constants.CHARSET_GB18030.equals(charset) && ContentDetectionUtils.isUTF8(buf, 0, totalBytesRead)) {
            return Constants.CHARSET_UTF_8;
        }
        return charset;
    }

    @Nullable
    public static String detectEncoding(@Nonnull byte[] buffer) {
        if (Objects.requireNonNull(buffer, "buffer").length < 4) {
            return null;
        }
        return ContentDetectionUtils.detectWithUniversalDetector(buffer, 0, buffer.length);
    }

    public static boolean isBinary(@Nonnull ByteBuffer buffer) {
        if (!Objects.requireNonNull(buffer, "buffer").hasRemaining()) {
            return false;
        }
        if (buffer.hasArray()) {
            return ContentDetectionUtils.isBinary(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
        }
        byte[] buf = ContentDetectionUtils.copyBuffer(buffer);
        return ContentDetectionUtils.isBinary(buf, 0, buf.length);
    }

    public static boolean isBinary(@Nonnull InputStream stream, int bufferSize) throws IOException {
        int b;
        Objects.requireNonNull(stream, "stream");
        Preconditions.checkArgument((boolean)stream.markSupported(), (Object)"Binary detection requires a stream which supports mark/reset.");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Binary detection requires a positive buffer size.");
        byte[] buf = new byte[4];
        stream.mark(5);
        int read = stream.read(buf);
        stream.reset();
        if (read > 3) {
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(buf, 0, read);
            if (detector.isDone()) {
                return false;
            }
        }
        stream.mark(bufferSize);
        for (read = 0; read < bufferSize && (b = stream.read()) != -1; ++read) {
            if (b != 0) continue;
            stream.reset();
            return true;
        }
        stream.reset();
        return false;
    }

    public static boolean isBinary(@Nonnull byte[] buffer) {
        return ContentDetectionUtils.isBinary(buffer, 0, buffer.length);
    }

    private static byte[] copyBuffer(@Nonnull ByteBuffer buffer) {
        buffer.mark();
        try {
            byte[] buf = new byte[buffer.remaining()];
            buffer.get(buf);
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            buffer.reset();
        }
    }

    private static String detectWithUniversalDetector(@Nonnull byte[] buffer, int offset, int length) {
        Objects.requireNonNull(buffer, "buffer");
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset cannot be negative.");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Buffer length cannot be negative.");
        Preconditions.checkArgument((buffer.length - length >= offset ? 1 : 0) != 0, (Object)"Buffer length must be within bounds.");
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(buffer, offset, length);
        detector.dataEnd();
        String charset = ContentDetectionUtils.getDetectedCharset(detector);
        if (Constants.CHARSET_GB18030.equals(charset) && ContentDetectionUtils.isUTF8(buffer, offset, length)) {
            return Constants.CHARSET_UTF_8;
        }
        return charset;
    }

    private static String getDetectedCharset(UniversalDetector detector) {
        String encoding = detector.getDetectedCharset();
        if (encoding != null && Charset.isSupported(encoding) && !"US-ASCII".equals(encoding)) {
            return encoding;
        }
        return null;
    }

    private static boolean isBinary(byte[] buffer, int offset, int count) {
        Objects.requireNonNull(buffer, "buffer");
        if (count > 3) {
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(buffer, offset, 4);
            if (detector.isDone()) {
                return false;
            }
        }
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            if (buffer[i] != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isUTF8(@Nonnull byte[] buffer, int offset, int length) {
        Objects.requireNonNull(buffer, "buffer");
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset cannot be negative.");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Buffer length cannot be negative.");
        Preconditions.checkArgument((buffer.length - length >= offset ? 1 : 0) != 0, (Object)"Buffer length must be within bounds.");
        UTF8Prober prober = new UTF8Prober();
        prober.handleData(buffer, offset, length);
        return prober.getConfidence() >= 0.95f;
    }
}

