/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class LineReader
implements Closeable,
Iterable<String> {
    public static final int NEWLINE = 10;
    public static final int CARRIAGERETURN = 13;
    public static final int NULL = 0;
    private final StringBuilder buffer;
    private final Deque<String> lineBuffer;
    private Mode fileMode;
    private int readAhead;

    protected LineReader(Mode fileMode) {
        this.fileMode = fileMode;
        this.buffer = new StringBuilder();
        this.lineBuffer = new LinkedList<String>();
        this.readAhead = -1;
    }

    protected LineReader() {
        this(Mode.MODE_DETECT);
    }

    public void forEach(int maxLength, @Nonnull Consumer<? super String> action) {
        this.stream(maxLength).forEach(action);
    }

    @Override
    @Nonnull
    public Iterator<String> iterator() {
        return this.makeIterator(this::readLine);
    }

    public Iterator<String> iterator(int maxLength) {
        return this.makeIterator(() -> this.readLine(maxLength));
    }

    public String readLine() throws IOException {
        if (this.lineBuffer.size() > 0) {
            return this.lineBuffer.pop();
        }
        this.buffer.setLength(0);
        int i = this.readNext();
        if (i == -1) {
            return null;
        }
        while (i != -1 && !this.isEOL(i)) {
            this.buffer.append((char)i);
            i = this.readNext();
        }
        return this.buffer.toString();
    }

    public String readLine(int maxLength) throws IOException {
        if (this.lineBuffer.size() > 0) {
            String line = this.lineBuffer.pop();
            if (line.length() > maxLength) {
                return line.substring(0, maxLength);
            }
            return line;
        }
        this.buffer.setLength(0);
        int i = this.readNext();
        if (i == -1) {
            return null;
        }
        while (i != -1 && !this.isEOL(i)) {
            if (this.buffer.length() < maxLength) {
                this.buffer.append((char)i);
            }
            i = this.readNext();
        }
        return this.buffer.toString();
    }

    public void pushLineBack(String line) {
        this.lineBuffer.push(line);
    }

    @Nonnull
    public Stream<String> stream() {
        return this.makeStream(this.iterator());
    }

    @Nonnull
    public Stream<String> stream(int maxLength) {
        return this.makeStream(this.iterator(maxLength));
    }

    protected abstract int read() throws IOException;

    private boolean isEOL(int i) throws IOException {
        return switch (this.fileMode.ordinal()) {
            case 1 -> i == 10;
            case 2 -> i == 13;
            case 3 -> {
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 == 10) {
                        yield true;
                    }
                    this.pushBack(i2);
                    yield false;
                }
                yield false;
            }
            case 0 -> {
                if (i == 10) {
                    this.fileMode = Mode.MODE_UNIX;
                    yield true;
                }
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 == 10) {
                        this.fileMode = Mode.MODE_PC;
                        yield true;
                    }
                    this.pushBack(i2);
                    this.fileMode = Mode.MODE_MAC;
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (i == 10) {
                    yield true;
                }
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 != 10) {
                        this.pushBack(i2);
                    }
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (i == 10) {
                    yield true;
                }
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 == 10) {
                        yield true;
                    }
                    this.pushBack(i2);
                    yield false;
                }
                yield false;
            }
            case 6 -> i == 0;
            default -> false;
        };
    }

    private Iterator<String> makeIterator(final LineSupplier supplier) {
        return new Iterator<String>(){
            private String next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                try {
                    this.next = supplier.get();
                    return this.next != null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    String line = this.next;
                    this.next = null;
                    return line;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Stream<String> makeStream(Iterator<String> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 272), false);
    }

    private void pushBack(int ch) {
        this.readAhead = ch;
    }

    private int readNext() throws IOException {
        int ch;
        if (this.readAhead == -1) {
            ch = this.read();
        } else {
            ch = this.readAhead;
            this.readAhead = -1;
        }
        return ch;
    }

    public static enum Mode {
        MODE_DETECT,
        MODE_UNIX,
        MODE_MAC,
        MODE_PC,
        MODE_MIXED,
        MODE_PC_UNIX_MIXED,
        MODE_NULL;

    }

    @FunctionalInterface
    private static interface LineSupplier {
        @Nullable
        public String get() throws IOException;
    }
}

