/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.ReaderLineReader;
import com.atlassian.bitbucket.scm.CommandOutputHandlerSupport;
import jakarta.annotation.Nonnull;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;

public abstract class LineReaderOutputHandler
extends BaseCommandHandler
implements CommandOutputHandlerSupport {
    private final Charset charset;
    private final LineReader.Mode newlineMode;

    protected LineReaderOutputHandler(Charset charset) {
        this(charset, LineReader.Mode.MODE_DETECT);
    }

    protected LineReaderOutputHandler(Charset charset, LineReader.Mode newlineMode) {
        this.charset = charset;
        this.newlineMode = newlineMode;
    }

    public void process(@Nonnull InputStream output) throws IOException {
        try (LineReader reader = this.createReader(output);){
            this.processReader(reader);
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }

    protected LineReader createReader(InputStream output) {
        return new ReaderLineReader(this.newlineMode, new InputStreamReader((InputStream)new BufferedInputStream(output), this.charset));
    }

    protected abstract void processReader(LineReader var1) throws IOException;
}

