/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import javax.annotation.WillClose;

public class PathOutputHandler
extends BaseCommandHandler
implements CommandOutputHandler<Boolean> {
    private final Path path;
    private long bytes;

    public PathOutputHandler(@Nonnull Path path) {
        this.path = Objects.requireNonNull(path, "path");
    }

    @Nonnull
    public Boolean getOutput() {
        return this.bytes > 0L;
    }

    public void process(@Nonnull @WillClose InputStream inputStream) {
        try (InputStream ignored = inputStream;){
            this.bytes = Files.copy(inputStream, this.path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Output could not be copied to " + String.valueOf(this.path.toAbsolutePath()), e);
        }
    }
}

