/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandlerSupport;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.nio.charset.Charset;

public class StringOutputHandler
extends BaseCommandHandler
implements CommandOutputHandlerSupport {
    private final Charset encoding;
    private final StringWriter writer;

    public StringOutputHandler() {
        this((Charset)null);
    }

    public StringOutputHandler(@Nullable Charset encoding) {
        this.encoding = (Charset)MoreObjects.firstNonNull((Object)encoding, (Object)Charset.defaultCharset());
        this.writer = new StringWriter();
    }

    public StringOutputHandler(@Nullable String encoding) {
        this(encoding == null ? null : Charset.forName(encoding));
    }

    public void complete() throws IOException {
        this.writer.close();
    }

    @Nonnull
    public String getOutput() {
        return this.writer.toString();
    }

    public void process(@Nonnull InputStream output) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(output, this.encoding);){
            int num;
            char[] buffer = new char[1024];
            while ((num = reader.read(buffer)) != -1) {
                this.resetWatchdog();
                this.writer.write(buffer, 0, num);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }
}

