/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.ReaderLineReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public abstract class TruncatedLineOutputHandler
extends BaseCommandHandler {
    private static final int BUFFER_SIZE = 8192;
    private static final int ENCODING_BUFFER_SIZE = 32768;
    private final Charset charset;
    private final int maxLineLength;
    private int counter;

    protected TruncatedLineOutputHandler(int maxLineLength) {
        this(maxLineLength, null);
    }

    protected TruncatedLineOutputHandler(int maxLineLength, @Nullable Charset charset) {
        this.charset = charset;
        this.maxLineLength = maxLineLength;
    }

    public int getLineNumber() {
        return this.counter;
    }

    public void process(@Nonnull InputStream output) throws IOException {
        BufferedInputStream bufferedIn = new BufferedInputStream(output, 8192);
        if (ContentDetectionUtils.isBinary(bufferedIn, 8192)) {
            try {
                this.handleBinary();
                return;
            }
            finally {
                this.cancelProcess();
            }
        }
        this.process(bufferedIn);
    }

    protected void process(BufferedInputStream in) throws IOException {
        try (LineReader reader = this.createReader(in, this.chooseCharset(in));){
            String line;
            while ((line = reader.readLine(this.maxLineLength + 3)) != null) {
                boolean truncated = false;
                if (line.length() > this.maxLineLength) {
                    truncated = true;
                    line = line.substring(0, this.maxLineLength);
                }
                this.processLine(this.counter++, line, truncated);
            }
            this.processInputEnd(this.counter);
        }
        catch (InterruptedIOException e) {
            this.processEndByException();
        }
        catch (IOException e) {
            this.processEndByException();
            throw e;
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException("The [" + e.getCharsetName() + "] character set is not supported", e);
        }
    }

    protected LineReader createReader(@Nonnull BufferedInputStream inputStream, @Nonnull Charset charset) throws IOException {
        return new ReaderLineReader(new InputStreamReader((InputStream)inputStream, charset));
    }

    protected abstract void handleBinary() throws IOException;

    protected void processEndByException() {
    }

    protected void processInputEnd(int lineCount) throws IOException {
    }

    protected abstract void processLine(int var1, String var2, boolean var3) throws IOException;

    private Charset chooseCharset(InputStream in) throws IOException {
        if (this.charset != null) {
            return this.charset;
        }
        String charsetName = ContentDetectionUtils.detectEncoding(in, 32768);
        if (StringUtils.isBlank((CharSequence)charsetName)) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(charsetName);
    }
}

