/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.protocol;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractScmRequestHandlerModuleDescriptor;
import com.atlassian.bitbucket.scm.ScmProtocol;
import com.atlassian.bitbucket.scm.ScmUrlFormatter;
import com.atlassian.bitbucket.scm.ScmUrlRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.util.ClassUtils;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginScmProtocol<D extends AbstractScmRequestHandlerModuleDescriptor>
implements ScmProtocol {
    protected final Logger log;
    private final Class<D> descriptorClass;
    private final PluginAccessor pluginAccessor;
    private final Function<D, ScmUrlFormatter> toFormatter;
    private final ScmUrlFormatter urlFormatter;

    protected AbstractPluginScmProtocol(PluginAccessor pluginAccessor, ScmUrlFormatter urlFormatter) {
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor, "pluginAccessor");
        this.urlFormatter = Objects.requireNonNull(urlFormatter, "urlFormatter");
        this.descriptorClass = (Class)ClassUtils.getTypeArguments(AbstractPluginScmProtocol.class, this.getClass()).get(0);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.toFormatter = AbstractScmRequestHandlerModuleDescriptor::getUrlFormatter;
    }

    public String getCloneUrl(@Nonnull Repository repository, @Nullable ApplicationUser user) {
        Objects.requireNonNull(repository, "repository");
        String baseUrl = this.getBaseUrl();
        ScmUrlFormatter formatter = (ScmUrlFormatter)Iterables.getFirst((Iterable)Chainable.chain(this.getHandlerDescriptors()).filter(this.isScm(repository.getScmId())).transform(this.toFormatter).filter(Objects::nonNull), (Object)this.urlFormatter);
        try {
            return formatter.format(new ScmUrlRequest.Builder(repository, new URI(baseUrl)).user(user).build()).toASCIIString();
        }
        catch (URISyntaxException e) {
            this.log.warn("{}: Failed to format URL; using base URL", (Object)repository, (Object)e);
            Project project = repository.getProject();
            return String.format("%s/%s/%s", baseUrl, project.getKey().toLowerCase(Locale.US), repository.getSlug());
        }
    }

    public boolean supports(@Nonnull String scmId) {
        Objects.requireNonNull(scmId, "scmId");
        return Iterables.any(this.getHandlerDescriptors(), this.isScm(scmId)::test);
    }

    private List<D> getHandlerDescriptors() {
        ArrayList descriptors = new ArrayList(this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.descriptorClass));
        Collections.sort(descriptors);
        return descriptors;
    }

    private Predicate<D> isScm(String scmId) {
        return descriptor -> scmId.equals(descriptor.getScm());
    }
}

