/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class RefAccessRequest {
    private final RefAccessType accessType;
    private final List<MinimalRef> refs;
    private final Repository repository;

    RefAccessRequest(Builder builder) {
        this.accessType = builder.accessType;
        this.refs = builder.refs.build();
        this.repository = builder.repository;
    }

    @Nonnull
    public RefAccessType getAccessType() {
        return this.accessType;
    }

    @Nonnull
    public List<MinimalRef> getRefs() {
        return this.refs;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder
    extends BuilderSupport {
        private final RefAccessType accessType;
        private final ImmutableList.Builder<MinimalRef> refs;
        private final Repository repository;

        public Builder(@Nonnull Repository repository, @Nonnull RefAccessType accessType) {
            this.accessType = Objects.requireNonNull(accessType, "accessType");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.refs = ImmutableList.builder();
        }

        @Nonnull
        public RefAccessRequest build() {
            return new RefAccessRequest(this);
        }

        @Nonnull
        public Builder ref(@Nonnull MinimalRef value) {
            this.refs.add((Object)Objects.requireNonNull(value, "ref"));
            return this;
        }

        @Nonnull
        public Builder refs(@Nonnull Iterable<MinimalRef> value) {
            this.refs.addAll(Objects.requireNonNull(value, "ref"));
            return this;
        }
    }
}

